/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IExtraVariantHolder;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.interf.IModBlock;
import vazkii.arl.interf.IVariantHolder;
import vazkii.arl.item.ItemMod;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="autoreglib")
public final class ModelHandler {
    public static final HashMap<String, ModelResourceLocation> resourceLocations = new HashMap();

    @SubscribeEvent
    public static void onRegister(ModelRegistryEvent event) {
        for (IVariantHolder holder : ItemMod.variantHolders) {
            ModelHandler.registerModels(holder);
        }
    }

    @SubscribeEvent
    public static void onItemColorRegister(ColorHandlerEvent.Item event) {
        for (IVariantHolder holder : ItemMod.variantHolders) {
            Item item;
            if (!(holder instanceof IItemColorProvider)) continue;
            if (holder instanceof Block) {
                item = Item.func_150898_a((Block)((Block)holder));
            } else {
                if (!(holder instanceof Item)) continue;
                item = (Item)holder;
            }
            if (item == Items.field_190931_a) continue;
            event.getItemColors().func_186730_a(((IItemColorProvider)((Object)holder)).getItemColor(), new Item[]{item});
        }
    }

    @SubscribeEvent
    public static void onBlockColorRegister(ColorHandlerEvent.Block event) {
        for (IVariantHolder holder : ItemMod.variantHolders) {
            Block block;
            if (!(holder instanceof IBlockColorProvider)) continue;
            if (holder instanceof ItemBlock) {
                block = ((ItemBlock)holder).func_179223_d();
            } else {
                if (!(holder instanceof Block)) continue;
                block = (Block)holder;
            }
            event.getBlockColors().func_186722_a(((IBlockColorProvider)block).getBlockColor(), new Block[]{block});
        }
    }

    public static void registerModels(IVariantHolder holder) {
        if (holder instanceof Item) {
            String unique = holder.getUniqueModel();
            String prefix = holder.getPrefix();
            Item i = (Item)holder;
            ItemMeshDefinition def = holder.getCustomMeshDefinition();
            if (def != null) {
                ModelLoader.setCustomMeshDefinition((Item)((Item)holder), (ItemMeshDefinition)def);
            } else {
                ModelHandler.registerModels(i, prefix, holder.getVariants(), unique, false);
            }
            if (holder instanceof IExtraVariantHolder) {
                IExtraVariantHolder extra = (IExtraVariantHolder)holder;
                ModelHandler.registerModels(i, prefix, extra.getExtraVariants(), unique, true);
            }
        } else if (holder instanceof Block) {
            ModelHandler.registerBlock((Block)holder);
        }
    }

    public static void registerBlock(Block block) {
        IModBlock quarkBlock = (IModBlock)block;
        IStateMapper mapper = quarkBlock.getStateMapper();
        IProperty[] ignored = quarkBlock.getIgnoredProperties();
        if (mapper != null || ignored != null && ignored.length > 0) {
            if (mapper != null) {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
            } else {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(ignored).func_178441_a());
            }
        }
    }

    public static void registerModels(Item item, String prefix, String[] variants, String uniqueVariant, boolean extra) {
        Class clazz;
        IModBlock modBlock;
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IModBlock && (modBlock = (IModBlock)((ItemBlock)item).func_179223_d()).useBlockstateForItem() && (clazz = modBlock.getVariantEnum()) != null) {
            IProperty variantProp = modBlock.getVariantProp();
            boolean variantIgnored = false;
            IStateMapper mapper = modBlock.getStateMapper();
            IProperty[] ignored = modBlock.getIgnoredProperties();
            if (mapper == null && ignored != null && ignored.length > 0) {
                for (IProperty p : ignored) {
                    if (p != variantProp) continue;
                    variantIgnored = true;
                    break;
                }
            }
            if (!variantIgnored) {
                ModelHandler.registerVariantsDefaulted(item, (Block)modBlock, clazz, variantProp.func_177701_a());
                return;
            }
        }
        for (int i = 0; i < variants.length; ++i) {
            String var = variants[i];
            if (!extra && uniqueVariant != null) {
                var = uniqueVariant;
            }
            String name = prefix + var;
            ModelResourceLocation loc = new ModelResourceLocation(name, "inventory");
            if (!extra) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
                resourceLocations.put(ModelHandler.getKey(item, i), loc);
                continue;
            }
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{loc});
            resourceLocations.put(variants[i], loc);
        }
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Item item, Block b, Class<T> enumclazz, String variantHeader) {
        String baseName = Objects.requireNonNull(b.getRegistryName()).toString();
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l();
            ModelResourceLocation loc = new ModelResourceLocation(baseName, variantName);
            int i = e.ordinal();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
            resourceLocations.put(ModelHandler.getKey(item, i), loc);
        }
    }

    public static ModelResourceLocation getModelLocation(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return null;
        }
        return ModelHandler.getModelLocation(stack.func_77973_b(), stack.func_77952_i());
    }

    public static ModelResourceLocation getModelLocation(Item item, int meta) {
        String key = ModelHandler.getKey(item, meta);
        if (resourceLocations.containsKey(key)) {
            return resourceLocations.get(key);
        }
        return null;
    }

    private static String getKey(Item item, int meta) {
        return "i_" + item.getRegistryName() + "@" + meta;
    }
}

