/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.version;

import com.github.lunatrius.core.reference.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;

public class ForgeVersionCheck {
    public static ForgeVersion.Status getStatus(ComparableVersion versionRemote, ComparableVersion versionLocal) {
        int diff = versionRemote.compareTo(versionLocal);
        if (diff == 0) {
            return ForgeVersion.Status.UP_TO_DATE;
        }
        if (diff > 0) {
            return ForgeVersion.Status.OUTDATED;
        }
        return ForgeVersion.Status.AHEAD;
    }

    public static void notify(ModContainer container, ForgeVersion.Status status, ComparableVersion target, Map<ComparableVersion, String> changes, String url) {
        try {
            Map<ModContainer, ForgeVersion.CheckResult> versionMap = ForgeVersionCheck.getVersionMap();
            ForgeVersion.CheckResult checkResult = ForgeVersionCheck.getCheckResult(status, target, changes, url);
            if (versionMap != null && checkResult != null) {
                versionMap.put(container, checkResult);
            }
        }
        catch (Throwable t) {
            Reference.logger.error("Failed to notify Forge!", t);
        }
    }

    private static Map<ModContainer, ForgeVersion.CheckResult> getVersionMap() throws ReflectiveOperationException {
        try {
            Field field = ForgeVersion.class.getDeclaredField("results");
            field.setAccessible(true);
            return (Map)field.get(null);
        }
        catch (Throwable t) {
            Reference.logger.error("Failed to get the version map!", t);
            return null;
        }
    }

    private static ForgeVersion.CheckResult getCheckResult(ForgeVersion.Status status, ComparableVersion target, Map<ComparableVersion, String> changes, String url) throws ReflectiveOperationException {
        try {
            Constructor constructor = ForgeVersion.CheckResult.class.getDeclaredConstructor(ForgeVersion.Status.class, ComparableVersion.class, Map.class, String.class);
            constructor.setAccessible(true);
            return (ForgeVersion.CheckResult)constructor.newInstance(status, target, changes, url);
        }
        catch (Throwable t) {
            Reference.logger.error("Failed to construct the CheckResult object!", t);
            return null;
        }
    }
}

