/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.thirteen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.config.Configuration;

public class ConfigSpec {
    private ConfigSpec(Builder builder, Configuration cfg) {
        for (Builder.V v : builder.values) {
            v.build(cfg);
        }
    }

    public static class Builder {
        private List<V> values = new ArrayList<V>();
        private List<String> path = new ArrayList<String>();
        private String comment;

        private String getCurrentComment() {
            return this.comment == null ? "" : this.comment;
        }

        private String getCurrentCategory() {
            return this.path.get(this.path.size() - 1);
        }

        public Builder push(String p) {
            this.path.add(p);
            CV v = new CV(p, "", this.getCurrentComment());
            this.comment = null;
            this.values.add(v);
            return this;
        }

        public Builder pop() {
            this.path.remove(this.path.size() - 1);
            return this;
        }

        public IntValue defineInRange(String name, int def, int min, int max) {
            IV v = new IV(name, this.getCurrentCategory(), this.getCurrentComment(), def, min, max);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public DoubleValue defineInRange(String name, double def, double min, double max) {
            DV v = new DV(name, this.getCurrentCategory(), this.getCurrentComment(), def, min, max);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public BooleanValue define(String name, boolean def) {
            BV v = new BV(name, this.getCurrentCategory(), this.getCurrentComment(), def);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public <T> ConfigValue<T> define(String name, T def) {
            SV<T> v = new SV<T>(name, this.getCurrentCategory(), this.getCurrentComment(), def);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public <T extends Enum<T>> ConfigValue<T> defineEnum(String name, T def, T ... enumValues) {
            EV v = new EV(name, this.getCurrentCategory(), this.getCurrentComment(), def, enumValues);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public <T> ConfigValue<List<? extends T>> defineList(String name, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            LV<List<T>> v = new LV<List<T>>(name, this.getCurrentCategory(), this.getCurrentComment(), defaultValue, elementValidator, false);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public <T> ConfigValue<List<? extends T>> defineIntList(String name, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            LV<List<T>> v = new LV<List<T>>(name, this.getCurrentCategory(), this.getCurrentComment(), defaultValue, elementValidator, true);
            this.comment = null;
            this.values.add(v);
            return v.get();
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ConfigSpec build(Configuration cfg) {
            return new ConfigSpec(this, cfg);
        }

        private static class CV
        extends V {
            public CV(String name, String category, String comment) {
                super(name, category, comment);
            }

            @Override
            public void build(Configuration cfg) {
                if (this.comment != null) {
                    cfg.addCustomCategoryComment(this.name, this.comment);
                }
            }
        }

        private static class IV
        extends V {
            private final IntValue value;
            private final int min;
            private final int max;

            public IV(String name, String category, String comment, int def, int min, int max) {
                super(name, category, comment);
                this.value = new IntValue(def);
                this.min = min;
                this.max = max;
            }

            public IntValue get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                this.value.set(cfg.getInt(this.name, this.category, this.value.get(), this.min, this.max, this.comment));
            }
        }

        private static class DV
        extends V {
            private final DoubleValue value;
            private final double min;
            private final double max;

            public DV(String name, String category, String comment, double def, double min, double max) {
                super(name, category, comment);
                this.value = new DoubleValue(def);
                this.min = min;
                this.max = max;
            }

            public DoubleValue get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                this.value.set(cfg.getFloat(this.name, this.category, (float)this.value.get(), (float)this.min, (float)this.max, this.comment));
            }
        }

        private static class BV
        extends V {
            private final BooleanValue value;

            public BV(String name, String category, String comment, boolean def) {
                super(name, category, comment);
                this.value = new BooleanValue(def);
            }

            public BooleanValue get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                this.value.set(cfg.getBoolean(this.name, this.category, this.value.get(), this.comment));
            }
        }

        private static class SV<T>
        extends V {
            private final ConfigValue<T> value;

            public SV(String name, String category, String comment, T def) {
                super(name, category, comment);
                this.value = new ConfigValue<T>(def);
            }

            public ConfigValue<T> get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                String result = cfg.getString(this.name, this.category, this.value.get().toString(), this.comment);
                this.value.set(result);
            }
        }

        private static class EV<T extends Enum<T>>
        extends V {
            private final ConfigValue<T> value;
            private final T[] values;

            public EV(String name, String category, String comment, T def, T ... values) {
                super(name, category, comment);
                this.values = values;
                this.value = new ConfigValue<T>(def);
            }

            public ConfigValue<T> get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                String cmt = this.comment == null ? "" : this.comment + " ";
                ArrayList<String> validValues = new ArrayList<String>();
                boolean first = true;
                for (T t : this.values) {
                    validValues.add(((Enum)t).name());
                    cmt = cmt + (first ? "(" : ",");
                    cmt = cmt + ((Enum)t).name();
                    first = false;
                }
                cmt = cmt + ")";
                String[] valid = validValues.toArray(new String[validValues.size()]);
                String result = cfg.getString(this.name, this.category, ((Enum)this.value.get()).name(), cmt, valid, valid);
                for (T t : this.values) {
                    if (!((Enum)t).name().equalsIgnoreCase(result)) continue;
                    this.value.set(t);
                    return;
                }
                int ord = Integer.parseInt(result);
                for (T t : this.values) {
                    if (((Enum)t).ordinal() != ord) continue;
                    this.value.set(t);
                    return;
                }
                throw new IllegalArgumentException("Unknown value '" + result + "' for configuration '" + this.name + "'!");
            }
        }

        private static class LV<T extends List<?>>
        extends V {
            private final ConfigValue<T> value;
            private final Predicate<Object> elementValidator;
            private final boolean asInt;

            public LV(String name, String category, String comment, T def, Predicate<Object> elementValidator, boolean asInt) {
                super(name, category, comment);
                this.elementValidator = elementValidator;
                this.value = new ConfigValue<T>(def);
                this.asInt = asInt;
            }

            public ConfigValue<T> get() {
                return this.value;
            }

            @Override
            public void build(Configuration cfg) {
                ArrayList<Integer> rc;
                List objects = (List)this.value.get();
                String[] def = new String[objects.size()];
                int i = 0;
                for (Object o : objects) {
                    def[i++] = o.toString();
                }
                String[] result = cfg.getStringList(this.name, this.category, def, this.comment);
                if (this.asInt) {
                    rc = new ArrayList<Integer>();
                    for (String s : result) {
                        rc.add(Integer.parseInt(s));
                    }
                    this.value.set(rc);
                } else {
                    rc = new ArrayList();
                    Collections.addAll(rc, result);
                    this.value.set(rc);
                }
            }
        }

        private static abstract class V {
            protected final String name;
            protected final String category;
            protected final String comment;

            public V(String name, String category, String comment) {
                this.name = name;
                this.category = category;
                this.comment = comment;
            }

            public abstract void build(Configuration var1);
        }
    }

    public static class ConfigValue<T> {
        private T value;

        public ConfigValue(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        @Deprecated
        public void set(T value) {
            this.value = value;
        }
    }

    public static class IntValue {
        private int value;

        public IntValue(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        @Deprecated
        public void set(int value) {
            this.value = value;
        }
    }

    public static class DoubleValue {
        private double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        public double get() {
            return this.value;
        }

        @Deprecated
        public void set(double value) {
            this.value = value;
        }
    }

    public static class BooleanValue {
        private boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        public boolean get() {
            return this.value;
        }

        @Deprecated
        public void set(boolean value) {
            this.value = value;
        }
    }
}

