/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import mcjty.lib.base.ModBase;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.network.IServerCommand;
import mcjty.lib.network.PacketSendPreferencesToClient;
import mcjty.lib.network.PacketSetGuiStyle;
import mcjty.lib.preferences.PreferencesDispatcher;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.proxy.IProxy;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod(modid="mcjtylib_ng", name="McJtyLib Refilmed", acceptedMinecraftVersions="[1.12,1.13)", version="3.5.5", dependencies="after:forge@[14.23.5.2800,);after:enderio@[5.0.21,)")
public class McJtyLib
implements ModBase {
    public static final String VERSION = "3.5.5";
    public static final String PROVIDES = "mcjtylib_ng";
    private static final ResourceLocation PREFERENCES_CAPABILITY_KEY;
    @CapabilityInject(value=PreferencesProperties.class)
    public static Capability<PreferencesProperties> PREFERENCES_CAPABILITY;
    @SidedProxy(clientSide="mcjty.lib.proxy.ClientProxy", serverSide="mcjty.lib.proxy.ServerProxy")
    public static IProxy proxy;
    public static ModSetup setup;
    @Mod.Instance(value="mcjtylib_ng")
    public static McJtyLib instance;
    public static SimpleNetworkWrapper networkHandler;
    private static boolean init;
    public static boolean tesla;
    public static boolean cofhapiitem;
    private static final Map<Pair<String, String>, IServerCommand> serverCommands;
    private static final Map<Pair<String, String>, IServerCommand> clientCommands;
    private static final Map<String, ModBase> mods;

    public static void registerMod(ModBase mod) {
        mods.put(mod.getModId(), mod);
    }

    public static void forEachMod(Consumer<ModBase> consumer) {
        for (ModBase mod : mods.values()) {
            consumer.accept(mod);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerAboutToStartEvent event) {
        Logging.log("Preparing all world data");
        AbstractWorldData.clearInstances();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log("Cleaning up all world data: " + AbstractWorldData.getDataCount() + " data blobs");
        AbstractWorldData.clearInstances();
    }

    @Override
    public String getModId() {
        return PROVIDES;
    }

    @Override
    public void openManual(EntityPlayer player, int bookindex, String page) {
    }

    public static void registerCommand(String modid, String id, IServerCommand command) {
        serverCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static void registerClientCommand(String modid, String id, IServerCommand command) {
        clientCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static boolean handleCommand(String modid, String id, EntityPlayer player, TypedMap arguments) {
        IServerCommand command = serverCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static boolean handleClientCommand(String modid, String id, EntityPlayer player, TypedMap arguments) {
        IServerCommand command = clientCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static void preInit(FMLPreInitializationEvent event) {
        if (init) {
            return;
        }
        McJtyLib.registerCapabilities();
        networkHandler = new SimpleNetworkWrapper(PROVIDES);
        networkHandler.registerMessage(PacketSendPreferencesToClient.Handler.class, PacketSendPreferencesToClient.class, 0, Side.CLIENT);
        networkHandler.registerMessage(PacketSetGuiStyle.Handler.class, PacketSetGuiStyle.class, 1, Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        init = true;
        tesla = Loader.isModLoaded((String)"tesla");
        cofhapiitem = Loader.isModLoaded((String)"cofhapi|item");
    }

    public static PreferencesProperties getPreferencesProperties(EntityPlayer player) {
        return (PreferencesProperties)player.getCapability(PREFERENCES_CAPABILITY, null);
    }

    @Mod.EventHandler
    public void actualPreInit(FMLPreInitializationEvent e) {
        setup.preInit(e);
        proxy.preInit(e);
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PreferencesProperties.class, (Capability.IStorage)new Capability.IStorage<PreferencesProperties>(){

            public NBTBase writeNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    static {
        setup = new ModSetup();
        serverCommands = new HashMap<Pair<String, String>, IServerCommand>();
        clientCommands = new HashMap<Pair<String, String>, IServerCommand>();
        mods = new HashMap<String, ModBase>();
        PREFERENCES_CAPABILITY_KEY = new ResourceLocation(PROVIDES, "Preferences");
    }

    public static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K) {
                PreferencesProperties preferencesProperties = McJtyLib.getPreferencesProperties(event.player);
                preferencesProperties.tick((EntityPlayerMP)event.player);
            }
        }

        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                if (!event.getCapabilities().containsKey(PREFERENCES_CAPABILITY_KEY) && !((Entity)event.getObject()).hasCapability(PREFERENCES_CAPABILITY, null)) {
                    event.addCapability(PREFERENCES_CAPABILITY_KEY, (ICapabilityProvider)new PreferencesDispatcher());
                } else {
                    throw new IllegalStateException(((Entity)event.getObject()).toString());
                }
            }
        }

        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
            BlockPos pos;
            World world = event.getWorld();
            IBlockState state = world.func_180495_p(pos = event.getPos());
            if (state.func_177230_c() instanceof MultipartBlock) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof MultipartTE && !world.field_72995_K && MultipartHelper.removePart((MultipartTE)tileEntity, state, event.getEntityPlayer(), event.getHitVec())) {
                    world.func_175698_g(pos);
                }
                event.setCanceled(true);
            }
        }
    }
}

