/*
 * Decompiled with CFR 0.152.
 */
package baubles.core.transformers;

import baubles.api.BaubleType;
import baubles.api.IBaubleType;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.inv.SlotDefinition;
import baubles.core.transformers.BaseTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class QualityToolsTransformer
extends BaseTransformer {
    public static byte[] transformBaublesHandler(byte[] basicClass) {
        ClassNode cls = QualityToolsTransformer.read(basicClass);
        Iterator mIterator = cls.methods.iterator();
        block0: while (mIterator.hasNext()) {
            MethodNode method = (MethodNode)mIterator.next();
            if (method.name.equals("canEquipBauble") || method.name.equals("getBaublesNamesForSlot")) {
                mIterator.remove();
                continue;
            }
            if (!method.name.equals("applyAttributesFromBaubles")) continue;
            for (AbstractInsnNode node : method.instructions) {
                if (node.getOpcode() != 183) continue;
                ((MethodInsnNode)node).desc = "(Lbaubles/api/cap/IBaublesItemHandler;I)Ljava/util/ArrayList;";
                node = node.getPrevious();
                method.instructions.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 3));
                continue block0;
            }
        }
        MethodVisitor m = cls.visitMethod(1, "canEquipBauble", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Z", null, null);
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, cls.name, "baublesExists", "Z");
        Label l_con1 = new Label();
        m.visitJumpInsn(153, l_con1);
        m.visitVarInsn(25, 1);
        m.visitFieldInsn(178, "baubles/api/cap/BaublesCapabilities", "CAPABILITY_ITEM_BAUBLE", "Lnet/minecraftforge/common/capabilities/Capability;");
        m.visitInsn(1);
        m.visitMethodInsn(182, "net/minecraft/item/ItemStack", "getCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", false);
        m.visitTypeInsn(192, "baubles/api/IBauble");
        m.visitVarInsn(58, 3);
        m.visitVarInsn(25, 3);
        Label l_con_cap_check = new Label();
        m.visitJumpInsn(198, l_con_cap_check);
        m.visitVarInsn(25, 3);
        m.visitVarInsn(25, 1);
        m.visitMethodInsn(185, "baubles/api/IBauble", "getType", "(Lnet/minecraft/item/ItemStack;)Lbaubles/api/IBaubleType;", true);
        m.visitVarInsn(58, 4);
        m.visitVarInsn(25, 4);
        m.visitFieldInsn(178, "baubles/api/BaubleType", "TRINKET", "Lbaubles/api/BaubleType;");
        m.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
        Label l_con_captrinket_check = new Label();
        m.visitJumpInsn(153, l_con_captrinket_check);
        m.visitInsn(4);
        m.visitInsn(172);
        m.visitLabel(l_con_captrinket_check);
        m.visitFrame(1, 2, new Object[]{"baubles/api/IBauble", "baubles/api/IBaubleType"}, 0, null);
        m.visitVarInsn(25, 2);
        m.visitLdcInsn((Object)"baubles_");
        m.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
        Label l_con_swith = new Label();
        m.visitJumpInsn(153, l_con_swith);
        m.visitVarInsn(25, 2);
        m.visitIntInsn(16, 8);
        m.visitMethodInsn(182, "java/lang/String", "substring", "(I)Ljava/lang/String;", false);
        m.visitMethodInsn(184, "baubles/api/BaubleType", "getType", "(Ljava/lang/String;)Lbaubles/api/IBaubleType;", false);
        m.visitVarInsn(58, 5);
        m.visitVarInsn(25, 5);
        m.visitFieldInsn(178, "baubles/api/BaubleType", "TRINKET", "Lbaubles/api/BaubleType;");
        m.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
        Label l_con_typetrinket_check = new Label();
        m.visitJumpInsn(153, l_con_typetrinket_check);
        m.visitInsn(4);
        m.visitInsn(172);
        m.visitLabel(l_con_typetrinket_check);
        m.visitFrame(1, 1, new Object[]{"baubles/api/IBaubleType"}, 0, null);
        m.visitVarInsn(25, 4);
        m.visitVarInsn(25, 5);
        m.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
        m.visitInsn(172);
        m.visitLabel(l_con_swith);
        m.visitFrame(2, 1, null, 0, null);
        m.visitInsn(3);
        m.visitInsn(172);
        m.visitLabel(l_con_cap_check);
        m.visitFrame(2, 1, null, 0, null);
        m.visitInsn(3);
        m.visitInsn(172);
        m.visitLabel(l_con1);
        m.visitFrame(2, 1, null, 0, null);
        m.visitInsn(3);
        m.visitInsn(172);
        m = cls.visitMethod(1, "getBaublesNamesForSlot", "(Lbaubles/api/cap/IBaublesItemHandler;I)Ljava/util/ArrayList;", null, null);
        m.visitVarInsn(25, 1);
        m.visitVarInsn(21, 2);
        m.visitMethodInsn(184, "baubles/core/transformers/QualityToolsTransformer", "$getBaublesNameForSlot", "(Lbaubles/api/cap/IBaublesItemHandler;I)Ljava/util/ArrayList;", false);
        m.visitInsn(176);
        return QualityToolsTransformer.write(cls);
    }

    public static ArrayList<String> $getBaublesNameForSlot(IBaublesItemHandler handler, int slot) {
        ArrayList<String> list = new ArrayList<String>();
        SlotDefinition definition = ((BaublesContainer)handler).getSlot(slot);
        for (Map.Entry<String, IBaubleType> type : BaubleType.getTypes().entrySet()) {
            if (!definition.canPutType(type.getValue())) continue;
            list.add("baubles_" + type.getKey());
        }
        return list;
    }
}

