/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.integration;

import baubles.api.BaubleType;
import baubles.api.cap.InjectableBauble;
import baubles.common.integration.StupidWingsEvents;
import de.ellpeck.actuallyadditions.mod.items.ItemBattery;
import de.ellpeck.actuallyadditions.mod.items.ItemMagnetRing;
import de.ellpeck.actuallyadditions.mod.items.ItemPotionRing;
import lain.mods.cos.client.GuiCosArmorInventory;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import yalter.mousetweaks.MTConfig;

public class ModCompatibility {
    public static final String MT = "mousetweaks";
    public static final String NRB = "norecipebook";
    public static final String UT = "universaltweaks";
    public static final String CA = "cosmeticarmorreworked";
    public static final String WINGS = "wings";
    public static final String AA = "actuallyadditions";

    public static boolean shouldScroll(Slot slot) {
        if (!Loader.isModLoaded((String)MT)) {
            return true;
        }
        boolean wheelTweaksEnabled = MTConfig.wheelTweak;
        return !wheelTweaksEnabled || slot == null || !slot.func_75216_d();
    }

    public static boolean isRecipeBookDisabled() {
        boolean disabled = Loader.isModLoaded((String)NRB);
        if (!disabled && Loader.isModLoaded((String)UT)) {
            disabled = UTConfigTweaks.MISC.utRecipeBookToggle;
        }
        return disabled;
    }

    public static boolean isCAInventory(Gui gui) {
        return Loader.isModLoaded((String)CA) && gui instanceof GuiCosArmorInventory;
    }

    public static void applyEvents() {
        if (Loader.isModLoaded((String)WINGS)) {
            MinecraftForge.EVENT_BUS.register(StupidWingsEvents.class);
        }
    }

    public static InjectableBauble getBaubleToInject(ItemStack stack) {
        Item item = stack.func_77973_b();
        ResourceLocation loc = item.getRegistryName();
        if (loc == null) {
            return null;
        }
        if (loc.func_110624_b().equals(AA)) {
            if (item instanceof ItemMagnetRing) {
                return new InjectableBauble(item, BaubleType.RING, true, 0);
            }
            if (item instanceof ItemBattery) {
                return new InjectableBauble(item, BaubleType.TRINKET, true, 0);
            }
            if (item instanceof ItemPotionRing && loc.func_110623_a().endsWith("advanced")) {
                return new InjectableBauble(item, BaubleType.RING, true, 0);
            }
        }
        return null;
    }
}

