/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.InjectableBauble;
import baubles.common.integration.ModCompatibility;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerItem {
    private static final ResourceLocation capabilityResourceLocation = new ResourceLocation("baubles", "bauble_cap");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void itemCapabilityAttach(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_190926_b()) {
            return;
        }
        final InjectableBauble bauble = ModCompatibility.getBaubleToInject(stack);
        if (bauble != null) {
            event.addCapability(capabilityResourceLocation, new ICapabilityProvider(){

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? BaublesCapabilities.CAPABILITY_ITEM_BAUBLE.cast((Object)bauble) : null);
                }
            });
            return;
        }
        if (!(stack.func_77973_b() instanceof IBauble) || stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            return;
        }
        event.addCapability(capabilityResourceLocation, new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? BaublesCapabilities.CAPABILITY_ITEM_BAUBLE.cast((Object)((IBauble)stack.func_77973_b())) : null);
            }
        });
    }

    @SubscribeEvent
    public void remapEntries(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation key = mapping.key;
            if (!key.func_110624_b().equals("actuallyadditions")) continue;
            String path = key.func_110623_a();
            if (path.endsWith("advanced_bauble")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemPotionRingAdvanced);
                continue;
            }
            if (path.startsWith("magnet")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemMagnetRing);
                continue;
            }
            if (path.equals("battery_bauble")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemBattery);
                continue;
            }
            if (path.endsWith("double_bauble")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemBatteryDouble);
                continue;
            }
            if (path.endsWith("triple_bauble")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemBatteryTriple);
                continue;
            }
            if (path.endsWith("quadruple_bauble")) {
                mapping.remap((IForgeRegistryEntry)InitItems.itemBatteryQuadruple);
                continue;
            }
            if (!path.endsWith("quintuple_bauble")) continue;
            mapping.remap((IForgeRegistryEntry)InitItems.itemBatteryQuintuple);
        }
    }
}

