/*
 * Decompiled with CFR 0.152.
 */
package baubles.client.gui;

import baubles.api.cap.BaublesContainer;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.inv.SlotDefinition;
import baubles.client.ClientProxy;
import baubles.client.gui.GuiSlotButton;
import baubles.common.container.ContainerPlayerExpanded;
import baubles.common.integration.ModCompatibility;
import baubles.common.network.PacketChangeOffset;
import baubles.common.network.PacketHandler;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.annotation.Nonnull;
import lain.mods.cos.CosmeticArmorReworked;
import lain.mods.cos.ModConfigs;
import lain.mods.cos.client.GuiCosArmorButton;
import lain.mods.cos.client.GuiCosArmorToggleButton;
import lain.mods.cos.client.PlayerRenderHandler;
import lain.mods.cos.network.NetworkPacket;
import lain.mods.cos.network.packet.PacketOpenCosArmorInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiStats;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.lwjgl.input.Mouse;

public class GuiPlayerExpanded
extends InventoryEffectRenderer {
    public static final ResourceLocation background = new ResourceLocation("baubles", "textures/gui/baubles_inventory.png");
    private static final boolean ENABLE_RECIPE_BOOK = !ModCompatibility.isRecipeBookDisabled();
    private static final Field REF_OLD_MOUSE_X;
    private static final Field REF_OLD_MOUSE_Y;
    private static final Method REF_ACTION_PERFORMED;
    private final EntityPlayer player;
    private final IBaublesItemHandler baublesHandler;
    protected GuiButtonImage recipeBook;
    protected GuiButton cosButton;
    protected GuiButton cosToggleButton;
    protected GuiSlotButton up;
    protected GuiSlotButton down;
    private float oldMouseX;
    private float oldMouseY;

    public GuiPlayerExpanded(EntityPlayer player) {
        super((Container)new ContainerPlayerExpanded(player.field_71071_by, player));
        this.baublesHandler = ((ContainerPlayerExpanded)this.field_147002_h).baubles;
        this.field_146291_p = true;
        this.player = player;
    }

    private void resetGuiLeft() {
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
    }

    public void func_73876_c() {
        ((ContainerPlayerExpanded)this.field_147002_h).baubles.setEventBlock(false);
        this.func_175378_g();
        this.resetGuiLeft();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.up = new GuiSlotButton(56, (GuiContainer)this, this.field_147003_i - 26, this.field_147009_r - 9, 27, 14, false);
        this.down = new GuiSlotButton(57, (GuiContainer)this, this.field_147003_i - 26, this.field_147009_r + 7 + this.getMaxY(), 27, 14, true);
        this.down.field_146125_m = this.up.field_146125_m = this.baublesHandler.getSlots() > this.getActualMaxBaubleSlots();
        this.field_146292_n.add(this.up);
        this.field_146292_n.add(this.down);
        if (ENABLE_RECIPE_BOOK) {
            this.initRecipeBook();
            this.field_146292_n.add(this.recipeBook);
        }
        if (Loader.isModLoaded((String)"cosmeticarmorreworked")) {
            this.initCosButtons();
            this.field_146292_n.add(this.cosButton);
            this.field_146292_n.add(this.cosToggleButton);
        }
        this.resetGuiLeft();
    }

    private void initRecipeBook() {
        this.recipeBook = new GuiButtonImage(10, this.field_147003_i + 104, this.field_146295_m / 2 - 22, 20, 18, 178, 0, 19, field_147001_a);
    }

    @Optional.Method(modid="cosmeticarmorreworked")
    private void initCosButtons() {
        if (!ModConfigs.CosArmorGuiButton_Hidden) {
            this.cosButton = new GuiCosArmorButton(58, this.field_147003_i + ModConfigs.CosArmorGuiButton_Left, this.field_147009_r + ModConfigs.CosArmorGuiButton_Top, 10, 10, "cos.gui.buttoncos"){

                public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
                    boolean pressed = super.func_146116_c(mc, mouseX, mouseY);
                    if (pressed) {
                        CosmeticArmorReworked.network.sendToServer((NetworkPacket)new PacketOpenCosArmorInventory());
                    }
                    return pressed;
                }
            };
        }
        if (!ModConfigs.CosArmorToggleButton_Hidden) {
            GuiCosArmorToggleButton toggleButton = new GuiCosArmorToggleButton(59, this.field_147003_i + ModConfigs.CosArmorToggleButton_Left, this.field_147009_r + ModConfigs.CosArmorToggleButton_Top, 5, 5, ""){

                public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
                    boolean pressed = super.func_146116_c(mc, mouseX, mouseY);
                    if (pressed) {
                        PlayerRenderHandler.HideCosArmor = !PlayerRenderHandler.HideCosArmor;
                        this.state = PlayerRenderHandler.HideCosArmor ? 1 : 0;
                    }
                    return pressed;
                }
            };
            toggleButton.state = PlayerRenderHandler.HideCosArmor ? 1 : 0;
            this.cosToggleButton = toggleButton;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int yLoc;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97, 8, 0x404040);
        int xLoc = this.field_147003_i - 24;
        if (mouseX > xLoc && mouseX < xLoc + 19 && mouseY >= (yLoc = this.field_147009_r + 5) && mouseY < yLoc + this.getMaxY()) {
            BaublesContainer container = (BaublesContainer)this.baublesHandler;
            int slotIndex = (mouseY - yLoc) / 18;
            ItemStack stack = container.getStack(slotIndex);
            if (!stack.func_190926_b()) {
                return;
            }
            SlotDefinition definition = container.getSlot(slotIndex);
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            String str = I18n.func_135052_a((String)definition.getTranslationKey(slotIndex), (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Collections.singletonList(str), (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r), (int)this.field_146294_l, (int)this.field_146295_m, (int)300, (FontRenderer)renderer);
            GlStateManager.func_179121_F();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        int dWheel;
        super.func_146274_d();
        if (this.baublesHandler.getSlots() <= this.getActualMaxBaubleSlots()) {
            return;
        }
        if (ModCompatibility.shouldScroll(this.getSlotUnderMouse()) && (dWheel = Mouse.getEventDWheel()) != 0) {
            int value = -(dWheel / 120);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketChangeOffset(value));
            ((BaublesContainer)this.baublesHandler).incrOffset(value);
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        int maxSlots = this.getMaxBaubleSlots();
        if (maxSlots > 0) {
            if (maxSlots == 1) {
                this.func_73729_b(k - 28, l, 176, 34, 28, 28);
            } else {
                for (int i = 0; i < maxSlots; ++i) {
                    int textureY = 39;
                    int height = 20;
                    int y = l + i * 18;
                    if (i == 0) {
                        textureY = 34;
                        height += 4;
                    } else {
                        y += 5;
                    }
                    if (i == maxSlots - 1) {
                        height += 4;
                    }
                    this.func_73729_b(k - 28, y, 176, textureY, 28, height);
                }
            }
        }
        GuiInventory.func_147046_a((int)(k + 51), (int)(l + 75), (int)30, (float)((float)(k + 51) - this.oldMouseX), (float)((float)(l + 75 - 50) - this.oldMouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiStats((GuiScreen)this, this.field_146297_k.field_71439_g.func_146107_m()));
                break;
            }
            case 10: {
                this.openInventoryWithRecipeBook(new GuiInventory(this.player));
            }
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == ClientProxy.KEY_BAUBLES.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    protected void func_175378_g() {
        boolean hasVisibleEffect = false;
        for (PotionEffect potioneffect : this.field_146297_k.field_71439_g.func_70651_bq()) {
            Potion potion = potioneffect.func_188419_a();
            if (!potion.shouldRender(potioneffect)) continue;
            hasVisibleEffect = true;
            break;
        }
        if (this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || !hasVisibleEffect) {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.field_147045_u = false;
        } else {
            this.field_147045_u = true;
        }
    }

    protected void func_147044_g() {
        this.field_147003_i -= 27;
        super.func_147044_g();
        this.field_147003_i += 27;
    }

    public void displayNormalInventory() {
        GuiInventory gui = new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g);
        try {
            REF_OLD_MOUSE_Y.set(gui, Float.valueOf(this.oldMouseX));
            REF_OLD_MOUSE_Y.set(gui, Float.valueOf(this.oldMouseY));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.field_146297_k.func_147108_a((GuiScreen)gui);
    }

    private void openInventoryWithRecipeBook(GuiInventory inventory) {
        this.field_146297_k.func_147108_a((GuiScreen)inventory);
        if (!inventory.func_194310_f().func_191878_b()) {
            try {
                assert (REF_ACTION_PERFORMED != null);
                REF_ACTION_PERFORMED.invoke((Object)inventory, this.recipeBook);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getMaxY() {
        return 18 * this.getMaxBaubleSlots();
    }

    public int getBaubleSlots() {
        return this.baublesHandler.getSlots();
    }

    public int getMaxBaubleSlots() {
        return Math.min(this.baublesHandler.getSlots(), this.getActualMaxBaubleSlots());
    }

    public int getActualMaxBaubleSlots() {
        return 8;
    }

    static {
        boolean deobfEnv = FMLLaunchHandler.isDeobfuscatedEnvironment();
        try {
            REF_OLD_MOUSE_X = GuiInventory.class.getDeclaredField(deobfEnv ? "oldMouseX" : "field_147048_u");
            REF_OLD_MOUSE_Y = GuiInventory.class.getDeclaredField(deobfEnv ? "oldMouseY" : "field_147047_v");
            REF_OLD_MOUSE_X.setAccessible(true);
            REF_OLD_MOUSE_Y.setAccessible(true);
            if (ENABLE_RECIPE_BOOK) {
                REF_ACTION_PERFORMED = GuiInventory.class.getDeclaredMethod(deobfEnv ? "actionPerformed" : "func_146284_a", GuiButton.class);
                REF_ACTION_PERFORMED.setAccessible(true);
            } else {
                REF_ACTION_PERFORMED = null;
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

