/*
 * Decompiled with CFR 0.152.
 */
package baubles.client;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.IBaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.client.ClientProxy;
import baubles.client.gui.GuiBaublesButton;
import baubles.client.gui.GuiPlayerExpanded;
import baubles.common.integration.ModCompatibility;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketOpenBaublesInventory;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientEventHandler {
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            IBauble bauble = (IBauble)event.getItemStack().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
            IBaubleType bt = Objects.requireNonNull(bauble).getType(event.getItemStack());
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"baubles.item.desc", (Object[])new Object[]{I18n.func_135052_a((String)bt.getTranslationKey(), (Object[])new Object[0])}));
        }
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        for (String type : BaubleType.getTypes().keySet()) {
            map.func_174942_a(new ResourceLocation("baubles", "gui/slots/" + type));
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71415_G && ClientProxy.KEY_BAUBLES.func_151468_f()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenBaublesInventory());
        }
    }

    @SubscribeEvent
    public void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots() > 0) {
            String buttonKey;
            GuiScreen gui = event.getGui();
            boolean normalInv = gui instanceof GuiInventory || ModCompatibility.isCAInventory((Gui)gui);
            boolean expandedInv = gui instanceof GuiPlayerExpanded;
            String string = buttonKey = normalInv ? "button.baubles" : "button.normal";
            if (normalInv || expandedInv) {
                GuiContainer container = (GuiContainer)event.getGui();
                event.getButtonList().add(new GuiBaublesButton(55, container, 64, 9, 10, 10, I18n.func_135052_a((String)(event.getGui() instanceof GuiInventory ? "button.baubles" : "button.normal"), (Object[])new Object[0])));
            }
        }
    }
}

