/*
 * Decompiled with CFR 0.152.
 */
package baubles.client;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.render.IRenderBauble;
import baubles.common.Config;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;

public final class BaublesRenderLayer
implements LayerRenderer<EntityPlayer> {
    public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!Config.renderBaubles || player.func_70660_b(MobEffects.field_76441_p) != null) {
            return;
        }
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler(player);
        this.dispatchRenders(inv, player, IRenderBauble.RenderType.BODY, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, partialTicks);
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        this.dispatchRenders(inv, player, IRenderBauble.RenderType.HEAD, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, partialTicks);
        GlStateManager.func_179121_F();
    }

    private void dispatchRenders(IBaublesItemHandler inv, EntityPlayer player, IRenderBauble.RenderType type, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, float partialTicks) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            IBauble bauble;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !(bauble = (IBauble)Objects.requireNonNull(stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null))).shouldRender(stack, player)) continue;
            IRenderBauble renderBauble = null;
            if (bauble instanceof IRenderBauble) {
                renderBauble = (IRenderBauble)((Object)bauble);
            } else if (stack.func_77973_b() instanceof IRenderBauble) {
                renderBauble = (IRenderBauble)stack.func_77973_b();
            }
            if (renderBauble == null) {
                throw new RuntimeException("Render Bauble is null for " + stack.func_77973_b().getRegistryName());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderBauble.onPlayerBaubleRender(stack, player, type, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, partialTicks);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

