/*
 * Decompiled with CFR 0.152.
 */
package baubles.api.cap;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.inv.SlotDefinition;
import baubles.common.Config;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BaublesContainer
implements IBaublesItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    private final ItemStack[] stacks;
    private final SlotDefinition[] slots = BaublesContainer.getDefaultSlots();
    private int offset = 0;
    private boolean[] changed;
    private boolean blockEvents = false;
    private EntityLivingBase player;
    private ItemStack[] itemsToPuke = null;

    public BaublesContainer() {
        this.stacks = new ItemStack[this.slots.length];
        this.changed = new boolean[this.slots.length];
    }

    public ItemStack getStack(int slot) {
        if (slot == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.stacks[this.getSlotIndex(slot)];
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    public void setStack(int slot, ItemStack stack) {
        this.stacks[this.getSlotIndex((int)slot)] = stack;
    }

    public SlotDefinition getSlot(int slot) {
        return this.slots[this.getSlotIndex(slot)];
    }

    public int getSlotIndex(int slot) {
        int slotGet = this.offset + slot;
        if (slotGet >= this.getSlots()) {
            slotGet -= this.getSlots();
        }
        return slotGet;
    }

    public int getOffset() {
        return this.offset;
    }

    public void incrOffset(int offset) {
        this.offset += offset;
        int slots = this.getSlots();
        this.offset %= slots;
        if (this.offset < 0) {
            this.offset += slots;
        } else if (this.offset >= slots) {
            this.offset -= slots;
        }
    }

    public void changeOffsetBasedOnSlot(int slot) {
        if ((slot += this.offset) < this.offset || slot > this.offset + 7) {
            this.offset = slot;
        }
    }

    public void resetOffset() {
        this.offset = 0;
    }

    protected void onContentsChanged(int slot) {
        this.setChanged(slot, true);
    }

    protected int validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return -1;
        }
        return slot;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack, EntityLivingBase player) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
        if (bauble != null) {
            return bauble.canEquip(stack, player) && this.getSlot(slot).canPutItem(slot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || this.isItemValidForSlot(slot, stack, this.player)) {
            this.setStack(slot, stack);
            this.setChanged(slot, true);
        }
    }

    public int getSlots() {
        return this.stacks.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = this.getStack(slot = this.validateSlotIndex(slot));
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.isItemValidForSlot(slot, stack, this.player)) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if ((slot = this.validateSlotIndex(slot)) == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        if ((slot = this.validateSlotIndex(slot)) == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStack(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStack(slot, ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }

    @Override
    public boolean isChanged(int slot) {
        if (this.changed == null) {
            this.changed = new boolean[this.getSlots()];
        }
        return this.changed[slot];
    }

    @Override
    public void setChanged(int slot, boolean change) {
        if (this.changed == null) {
            this.changed = new boolean[this.getSlots()];
        }
        this.changed[slot] = change;
    }

    @Override
    public void setPlayer(EntityLivingBase player) {
        this.player = player;
    }

    public void pukeItems(World world, double x, double y, double z) {
        if (this.itemsToPuke != null) {
            for (ItemStack stack : this.itemsToPuke) {
                EntityItem eItem = new EntityItem(world, x, y, z, stack);
                world.func_72838_d((Entity)eItem);
            }
            this.itemsToPuke = null;
        }
    }

    public void pukeItems(Entity entity) {
        this.pukeItems(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.getStack(i);
            if (stack == null || stack.func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a("Slot", i);
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Items", (NBTBase)list);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Items", 10);
        ArrayList<ItemStack> itemsToPuke = new ArrayList<ItemStack>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Item item;
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74762_e("Slot");
            if (!stackTag.func_150297_b("id", 8) || (item = Item.func_111206_d((String)stackTag.func_74779_i("id"))) == null || item == Items.field_190931_a) continue;
            ItemStack stack = new ItemStack(stackTag);
            if (slot < this.getSlots()) {
                if (this.slots[slot].canPutItem(slot, stack)) {
                    this.stacks[slot] = stack;
                    continue;
                }
                itemsToPuke.add(stack);
                continue;
            }
            itemsToPuke.add(new ItemStack(stackTag));
        }
        if (!itemsToPuke.isEmpty()) {
            this.itemsToPuke = itemsToPuke.toArray(new ItemStack[0]);
        }
    }

    private static SlotDefinition[] getDefaultSlots() {
        return Config.getSlots();
    }
}

