/*
 * Decompiled with CFR 0.152.
 */
package baubles.api;

import baubles.api.BaubleTypeImpl;
import baubles.api.IBaubleType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum BaubleType implements IBaubleType
{
    AMULET("amulet", new int[0]),
    RING("ring", new int[0]),
    BELT("belt", new int[0]),
    TRINKET("trinket", new int[0]),
    HEAD("head", new int[0]),
    BODY("body", new int[0]),
    CHARM("charm", new int[0]);

    private static final Map<String, IBaubleType> TYPES;
    final String name;
    final String translationKey;
    final String backgroundTexture;
    final IntList validSlots = new IntArrayList(1);

    private BaubleType(String name, int ... validSlots) {
        this.name = name;
        this.translationKey = "baubles.type." + name;
        this.backgroundTexture = "baubles:gui/slots/" + name;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    @Nonnull
    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void addSlot(int slot) {
        this.validSlots.add(slot);
    }

    public static Map<String, IBaubleType> getTypes() {
        return TYPES;
    }

    public static IBaubleType register(IBaubleType type) {
        TYPES.put(type.getName(), type);
        return type;
    }

    @Nullable
    public static IBaubleType getType(String name) {
        return TYPES.get(name);
    }

    public static IBaubleType getOrCreateType(String name) {
        IBaubleType baubleType = TYPES.get(name);
        if (baubleType == null) {
            baubleType = BaubleType.putType(name);
        }
        return baubleType;
    }

    private static IBaubleType putType(String name) {
        BaubleTypeImpl type = new BaubleTypeImpl(name);
        TYPES.put(name, type);
        return type;
    }

    @Deprecated
    public boolean hasSlot(int slot) {
        switch (slot) {
            default: {
                return false;
            }
            case 0: {
                return this == AMULET || this == TRINKET;
            }
            case 1: 
            case 2: {
                return this == RING || this == TRINKET;
            }
            case 3: {
                return this == BELT || this == TRINKET;
            }
            case 4: {
                return this == HEAD || this == TRINKET;
            }
            case 5: {
                return this == BODY || this == TRINKET;
            }
            case 6: 
        }
        return this == CHARM || this == TRINKET;
    }

    @Deprecated
    public int[] getValidSlots() {
        int[] array;
        if (this == RING) {
            array = new int[2];
            array[1] = -1;
        } else {
            array = new int[]{-1};
        }
        return this.validSlots.toArray(array);
    }

    static {
        TYPES = new HashMap<String, IBaubleType>();
        for (BaubleType type : BaubleType.values()) {
            TYPES.put(type.name, type);
        }
    }
}

