/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public class AdaptorItemRepository
extends InventoryAdaptor {
    protected final IItemRepository itemRepository;

    public AdaptorItemRepository(IItemRepository itemRepository) {
        this.itemRepository = itemRepository;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack rv = ItemStack.field_190927_a;
        ItemStack extracted = ItemStack.field_190927_a;
        if (!filter.func_190926_b()) {
            extracted = this.itemRepository.extractItem(filter, amount, true);
        } else {
            for (IItemRepository.ItemRecord record : this.itemRepository.getAllItems()) {
                extracted = this.itemRepository.extractItem(record.itemPrototype, amount, true);
                if (extracted.func_190926_b()) continue;
                break;
            }
        }
        if (destination != null && (extracted.func_190926_b() || !destination.canInsert(extracted))) {
            return rv;
        }
        extracted = this.itemRepository.extractItem(filter.func_190926_b() ? extracted : filter, amount, false);
        return extracted;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack rv = ItemStack.field_190927_a;
        ItemStack extracted = ItemStack.field_190927_a;
        if (!filter.func_190926_b()) {
            extracted = this.itemRepository.extractItem(filter, amount, true);
        } else {
            for (IItemRepository.ItemRecord record : this.itemRepository.getAllItems()) {
                extracted = this.itemRepository.extractItem(record.itemPrototype, amount, true);
                if (extracted.func_190926_b()) continue;
                break;
            }
        }
        if (destination != null && (extracted.func_190926_b() || !destination.canInsert(extracted))) {
            return rv;
        }
        return extracted;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack rv = ItemStack.field_190927_a;
        ItemStack extracted = ItemStack.field_190927_a;
        for (IItemRepository.ItemRecord record : this.itemRepository.getAllItems()) {
            if (Platform.itemComparisons().isFuzzyEqualItem(record.itemPrototype, filter, fuzzyMode)) {
                extracted = this.itemRepository.extractItem(record.itemPrototype, amount, true);
            }
            if (extracted.func_190926_b()) continue;
            break;
        }
        if (destination != null && (extracted.func_190926_b() || !destination.canInsert(extracted))) {
            return rv;
        }
        extracted = this.itemRepository.extractItem(extracted, amount, false);
        return extracted;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack rv = ItemStack.field_190927_a;
        ItemStack extracted = ItemStack.field_190927_a;
        for (IItemRepository.ItemRecord record : this.itemRepository.getAllItems()) {
            if (Platform.itemComparisons().isFuzzyEqualItem(record.itemPrototype, filter, fuzzyMode)) {
                extracted = this.itemRepository.extractItem(record.itemPrototype, amount, true);
            }
            if (extracted.func_190926_b()) continue;
            break;
        }
        if (destination != null && (extracted.func_190926_b() || !destination.canInsert(extracted))) {
            return rv;
        }
        return extracted;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, false);
    }

    protected ItemStack addItems(ItemStack itemsToAdd, boolean simulate) {
        if (itemsToAdd.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            itemsToAdd = itemsToAdd.func_77946_l();
        }
        if ((itemsToAdd = this.itemRepository.insertItem(itemsToAdd, simulate)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return itemsToAdd;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, true);
    }

    @Override
    public boolean containsItems() {
        return !this.itemRepository.getAllItems().isEmpty();
    }

    @Override
    public boolean hasSlots() {
        return true;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return null;
    }
}

