/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellGuiHandler;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.sync.GuiBridge;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class TileChest
extends AENetworkPowerTile
implements IMEChest,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile,
ITickable {
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final IItemHandler internalInventory = new WrapperChainedItemHandler(new IItemHandler[]{this.inputInventory, this.cellInventory});
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this);
    private long lastStateChange = 0L;
    private int priority = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private Accessor accessor;
    private IFluidHandler fluidHandler;
    private int cellState;
    private boolean powered = false;
    private int blinking;

    public TileChest() {
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(128.0));
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldCellState = this.cellState;
        boolean oldPowered = this.powered;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.cellState |= this.getCellStatus(x) << 3 * x;
        }
        this.powered = this.isPowered();
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldCellState != this.cellState || oldPowered != this.powered) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.accessor = null;
            this.fluidHandler = null;
            ItemStack is = this.getCell();
            if (!is.func_190926_b()) {
                this.isCached = true;
                ICellHandler cellHandler = AEApi.instance().registries().cell().getHandler(is);
                if (cellHandler != null) {
                    double power = 1.0;
                    for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : AEApi.instance().storage().storageChannels()) {
                        ICellInventoryHandler<? extends IAEStack<?>> newCell = cellHandler.getCellInventory(is, this, iStorageChannel);
                        if (newCell == null) continue;
                        power += cellHandler.cellIdleDrain(is, newCell);
                        this.cellHandler = this.wrap(newCell);
                        break;
                    }
                    this.getProxy().setIdlePowerUsage(power);
                    this.accessor = new Accessor();
                    if (this.cellHandler != null && this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                        this.fluidHandler = new FluidHandler();
                    }
                }
            }
        }
    }

    private <T extends IAEStack<T>> ChestMonitorHandler<T> wrap(IMEInventoryHandler<T> h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler<T> ih = new MEInventoryHandler<T>(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), g);
        return g;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.cellState >> slot * 3 & 7;
        }
        this.updateHandler();
        ItemStack cell = this.getCell();
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return ch.getStatusForCell(cell, this.cellHandler.getInternalHandler());
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (Platform.isClient()) {
            return this.powered;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            return false;
        }
        return (this.blinking & 1 << slot) == 1;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    public void func_73660_a() {
        block5: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            double idleUsage = this.getProxy().getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.getProxy().getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != this.powered) {
                    this.recalculateDisplay();
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.getProxy().getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == this.powered) break block5;
                this.recalculateDisplay();
            }
        }
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        if (this.field_145850_b.func_82737_E() - this.lastStateChange > 8L) {
            this.cellState = 0;
            this.powered = false;
            this.blinking = 0;
        } else {
            this.cellState = 0;
            this.powered = false;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.cellState |= this.getCellStatus(x) << 3 * x;
        }
        this.powered = this.isPowered();
        data.writeByte(this.cellState);
        data.writeBoolean(this.powered);
        data.writeByte(this.blinking);
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.cellState;
        boolean oldPowered = this.powered;
        int oldBlinking = this.blinking;
        this.cellState = data.readByte();
        this.powered = data.readBoolean();
        this.blinking = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.lastStateChange = this.field_145850_b.func_82737_E();
        return oldPaintedColor != this.paintedColor || this.cellState != oldState || c || oldPowered != this.powered || oldBlinking != this.blinking;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.config.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.config.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        this.updateHandler();
        if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.isCached = false;
            try {
                if (this.getProxy().isActive()) {
                    IStorageGrid gs = this.getProxy().getStorage();
                    Platform.postChanges(gs, removed, added, this.mySrc);
                }
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.field_145850_b != null) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && mc == InvOperation.INSERT) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull EnumFacing side) {
        if (side == this.getForward()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
            this.updateHandler();
            if (this.cellHandler != null && this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                IAEItemStack returns = Platform.poweredInsert(this, this.cellHandler, AEItemStack.fromItemStack(this.inputInventory.getStackInSlot(0)), this.mySrc);
                if (returns == null) {
                    this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
                } else {
                    this.inputInventory.setStackInSlot(0, returns.createItemStack());
                }
            }
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        this.updateHandler();
        if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
            return Collections.singletonList(this.cellHandler);
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.isCached = false;
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            this.cellState = 0;
            this.powered = false;
            this.blinking = 0;
        }
        this.lastStateChange = now;
        this.blinking |= 1 << slot;
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public boolean openGui(EntityPlayer p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = AEApi.instance().registries().cell().getHandler(this.getCell())) != null && (chg = AEApi.instance().registries().cell().getGuiHandler(this.cellHandler.getChannel(), this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.cellHandler, this.getCell(), this.cellHandler.getChannel());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(EnumFacing side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        if (cellInventory != null) {
            cellInventory.persist();
        }
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        this.updateHandler();
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return true;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        this.updateHandler();
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return (T)this.fluidHandler;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return (T)this.accessor;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return AEApi.instance().definitions().blocks().chest().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public GuiBridge getGuiBridge() {
        this.updateHandler();
        if (this.cellHandler != null) {
            if (this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return GuiBridge.GUI_ME;
            }
            if (this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                return GuiBridge.GUI_FLUID_TERMINAL;
            }
        }
        return null;
    }

    private class ChestMonitorHandler<T extends IAEStack<T>>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        private ICellInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (ICellInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return (ICellInventoryHandler)this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((EntityPlayer)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return input;
            }
            T injected = super.injectItems(input, mode, src);
            if (mode == Actionable.MODULATE && (injected == null || injected.getStackSize() != input.getStackSize()) && TileChest.this.isPowered() && this.getInternalHandler().getCellInv() != null) {
                TileChest.this.cellHandler.postChangesToListeners(Collections.singletonList(input.copy().setStackSize(input.getStackSize() - (injected == null ? 0L : injected.getStackSize()))), TileChest.this.mySrc);
            }
            return injected;
        }

        private boolean securityCheck(EntityPlayer player, SecurityPermissions requiredPermission) {
            if (TileChest.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                IGridNode gn = ((IActionHost)TileChest.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    boolean requirePower = false;
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    return sg.hasPermission(player, requiredPermission);
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((EntityPlayer)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return null;
            }
            T extracted = super.extractItems(request, mode, src);
            if (mode == Actionable.MODULATE && extracted != null && TileChest.this.isPowered() && this.getInternalHandler().getCellInv() != null) {
                TileChest.this.cellHandler.postChangesToListeners(Collections.singletonList(request.copy().setStackSize(-extracted.getStackSize())), TileChest.this.mySrc);
            }
            return extracted;
        }
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (TileChest.this.isPowered()) {
                TileChest.this.updateHandler();
                return TileChest.this.cellHandler != null && TileChest.this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            }
            return false;
        }
    }

    private class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return AEApi.instance().registries().cell().getHandler(stack) != null;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            if (Platform.canAccess(TileChest.this.getProxy(), src)) {
                return TileChest.this;
            }
            return null;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private final IFluidTankProperties[] TANK_PROPS = new IFluidTankProperties[]{new FluidTankProperties(null, 1000)};

        private FluidHandler() {
        }

        public int fill(FluidStack resource, boolean doFill) {
            TileChest.this.updateHandler();
            if (TileChest.this.cellHandler != null && TileChest.this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                IAEFluidStack results = Platform.poweredInsert(TileChest.this, TileChest.this.cellHandler, AEFluidStack.fromFluidStack(resource), TileChest.this.mySrc, doFill ? Actionable.MODULATE : Actionable.SIMULATE);
                if (results == null) {
                    return resource.amount;
                }
                return resource.amount - (int)results.getStackSize();
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            TileChest.this.updateHandler();
            if (TileChest.this.cellHandler != null && TileChest.this.cellHandler.getChannel() == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                return this.TANK_PROPS;
            }
            return null;
        }
    }

    private class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        private final IStorageChannel<T> chan;

        public ChestNetNotifier(IStorageChannel<T> chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            TileChest.this.updateHandler();
            if (TileChest.this.cellHandler != null && this.chan == TileChest.this.cellHandler.getChannel()) {
                return verificationToken == TileChest.this.cellHandler;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, IActionSource source) {
            try {
                if (TileChest.this.getProxy().isActive()) {
                    TileChest.this.getProxy().getStorage().postAlterationOfStoredItems(this.chan, change, TileChest.this.mySrc);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            TileChest.this.blinkCell(0);
        }

        @Override
        public void onListUpdate() {
        }
    }
}

