/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import ic2.api.energy.prefab.BasicSinkSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PartP2PIC2Power
extends PartP2PTunnel<PartP2PIC2Power> {
    private static final String TAG_BUFFERED_ENERGY_1 = "bufferedEnergy1";
    private static final String TAG_BUFFERED_ENERGY_2 = "bufferedEnergy2";
    private static final String TAG_BUFFERED_VOLTAGE_1 = "outputPacket1";
    private static final String TAG_BUFFERED_VOLTAGE_2 = "outputPacket2";
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_ic2");
    private double bufferedEnergy1;
    private double bufferedVoltage1;
    private double bufferedEnergy2;
    private double bufferedVoltage2;
    private BasicSinkSource sinkSource;

    public PartP2PIC2Power(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.bufferedEnergy1 = tag.func_74769_h(TAG_BUFFERED_ENERGY_1);
        this.bufferedEnergy2 = tag.func_74769_h(TAG_BUFFERED_ENERGY_2);
        this.bufferedVoltage1 = tag.func_74769_h(TAG_BUFFERED_VOLTAGE_1);
        this.bufferedVoltage2 = tag.func_74769_h(TAG_BUFFERED_VOLTAGE_2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a(TAG_BUFFERED_ENERGY_1, this.bufferedEnergy1);
        tag.func_74780_a(TAG_BUFFERED_ENERGY_2, this.bufferedEnergy2);
        tag.func_74780_a(TAG_BUFFERED_VOLTAGE_1, this.bufferedVoltage1);
        tag.func_74780_a(TAG_BUFFERED_VOLTAGE_2, this.bufferedVoltage2);
    }

    @Override
    public void onTunnelConfigChange() {
        this.updateSinkSource();
        this.getHost().partChanged();
    }

    @Override
    public void onTunnelNetworkChange() {
        this.updateSinkSource();
        this.getHost().notifyNeighbors();
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.invalidateSinkSource();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.updateSinkSource();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    private void updateSinkSource() {
        if (this.sinkSource == null) {
            this.sinkSource = new SinkSource(this.getHost().getTile().func_145831_w(), this.getHost().getLocation().getPos(), 2048, 4, 4);
        }
        this.sinkSource.update();
    }

    private void invalidateSinkSource() {
        if (this.sinkSource != null) {
            this.sinkSource.invalidate();
        }
    }

    private class SinkSource
    extends BasicSinkSource {
        SinkSource(World world, BlockPos pos, int i, int j, int k) {
            super(world, pos, (double)i, j, k);
        }

        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
            return PartP2PIC2Power.this.isOutput() && side == PartP2PIC2Power.this.getSide().getFacing();
        }

        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
            return !PartP2PIC2Power.this.isOutput() && side == PartP2PIC2Power.this.getSide().getFacing();
        }

        public double getDemandedEnergy() {
            if (PartP2PIC2Power.this.isOutput()) {
                return 0.0;
            }
            try {
                for (PartP2PIC2Power t : PartP2PIC2Power.this.getOutputs()) {
                    if (!(t.bufferedEnergy1 <= 1.0E-4) && !(t.bufferedEnergy2 <= 1.0E-4)) continue;
                    return 2048.0;
                }
            }
            catch (GridAccessException e) {
                return 0.0;
            }
            return 0.0;
        }

        public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
            TunnelCollection outs;
            try {
                outs = PartP2PIC2Power.this.getOutputs();
            }
            catch (GridAccessException e) {
                return amount;
            }
            if (outs.isEmpty()) {
                return amount;
            }
            ArrayList<PartP2PIC2Power> options = new ArrayList<PartP2PIC2Power>();
            for (PartP2PIC2Power o : outs) {
                if (!(o.bufferedEnergy1 <= 0.01)) continue;
                options.add(o);
            }
            if (options.isEmpty()) {
                for (PartP2PIC2Power o : outs) {
                    if (!(o.bufferedEnergy2 <= 0.01)) continue;
                    options.add(o);
                }
            }
            if (options.isEmpty()) {
                for (PartP2PIC2Power o : outs) {
                    options.add(o);
                }
            }
            if (options.isEmpty()) {
                return amount;
            }
            PartP2PIC2Power x = (PartP2PIC2Power)Platform.pickRandom(options);
            if (x != null && x.bufferedEnergy1 <= 0.001) {
                PartP2PIC2Power.this.queueTunnelDrain(PowerUnits.EU, amount);
                x.bufferedEnergy1 = amount;
                x.bufferedVoltage1 = voltage;
                return 0.0;
            }
            if (x != null && x.bufferedEnergy2 <= 0.001) {
                PartP2PIC2Power.this.queueTunnelDrain(PowerUnits.EU, amount);
                x.bufferedEnergy2 = amount;
                x.bufferedVoltage2 = voltage;
                return 0.0;
            }
            return amount;
        }

        public double getOfferedEnergy() {
            if (PartP2PIC2Power.this.isOutput()) {
                return PartP2PIC2Power.this.bufferedEnergy1;
            }
            return 0.0;
        }

        public void drawEnergy(double amount) {
            PartP2PIC2Power.this.bufferedEnergy1 -= amount;
            if (PartP2PIC2Power.this.bufferedEnergy1 < 0.001) {
                PartP2PIC2Power.this.bufferedEnergy1 = PartP2PIC2Power.this.bufferedEnergy2;
                PartP2PIC2Power.this.bufferedEnergy2 = 0.0;
                PartP2PIC2Power.this.bufferedVoltage1 = PartP2PIC2Power.this.bufferedVoltage2;
                PartP2PIC2Power.this.bufferedVoltage2 = 0.0;
            }
        }
    }
}

