/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.core.AELog;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingCalculationFailure;
import appeng.crafting.CraftingTreeNode;
import appeng.crafting.MECraftingInventory;
import appeng.hooks.TickHandler;
import appeng.me.cache.GridStorageCache;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class CraftingJob
implements Runnable,
ICraftingJob {
    private static final String LOG_CRAFTING_JOB = "CraftingJob (%s) issued by %s requesting [%s] using %s bytes took %s us";
    private static final String LOG_MACHINE_SOURCE_DETAILS = "Machine[object=%s, %s]";
    private final MECraftingInventory original;
    private final World world;
    private final IItemList<IAEItemStack> crafting = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IItemList<IAEItemStack> missing = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final HashMap<String, TwoIntegers> opsAndMultiplier = new HashMap();
    private final Object monitor = new Object();
    private final Stopwatch tickSpreadingWatch = Stopwatch.createUnstarted();
    private final Stopwatch craftingTreeWatch = Stopwatch.createUnstarted();
    private final ICraftingGrid cc;
    private CraftingTreeNode tree;
    private final IAEItemStack output;
    private boolean simulate = false;
    private MECraftingInventory availableCheck;
    private long bytes = 0L;
    private final IActionSource actionSrc;
    private final ICraftingCallback callback;
    private boolean running = false;
    private boolean done = false;
    private int time;
    private int incTime;

    private World wrapWorld(World w) {
        return w;
    }

    public CraftingJob(World w, IGrid grid, IActionSource actionSrc, IAEItemStack what, ICraftingCallback callback) {
        this.world = this.wrapWorld(w);
        this.output = what.copy();
        this.actionSrc = actionSrc;
        this.callback = callback;
        this.cc = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        GridStorageCache sg = (GridStorageCache)grid.getCache(IStorageGrid.class);
        this.original = new MECraftingInventory(sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).getStorageList());
        this.setTree(this.getCraftingTree(this.cc, what));
        this.availableCheck = null;
    }

    private CraftingTreeNode getCraftingTree(ICraftingGrid cc, IAEItemStack what) {
        return new CraftingTreeNode(cc, this, what, null, -1, 0);
    }

    void refund(IAEItemStack o) {
        this.availableCheck.injectItems(o, Actionable.MODULATE, this.actionSrc);
    }

    IAEItemStack checkUse(IAEItemStack available) {
        return this.availableCheck.extractItems(available, Actionable.MODULATE, this.actionSrc);
    }

    IAEItemStack checkAvailable(IAEItemStack available) {
        return this.availableCheck.extractItems(available, Actionable.SIMULATE, this.actionSrc);
    }

    void addTask(IAEItemStack what, long crafts, ICraftingPatternDetails details, int depth) {
        if (crafts > 0L) {
            what = what.copy();
            what.setStackSize(what.getStackSize() * crafts);
            this.crafting.add(what);
        }
    }

    void addMissing(IAEItemStack what) {
        what = what.copy();
        this.missing.add(what);
    }

    @Override
    public void run() {
        try {
            try {
                TickHandler.INSTANCE.registerCraftingSimulation(this.world, this);
                this.handlePausing();
                MECraftingInventory craftingInventory = new MECraftingInventory(this.original, true, false, true);
                craftingInventory.ignore(this.output);
                this.availableCheck = new MECraftingInventory(this.original, false, false, false);
                this.craftingTreeWatch.reset().start();
                this.getTree().request(craftingInventory, this.output.getStackSize(), this.actionSrc);
                this.craftingTreeWatch.stop();
                this.getTree().dive(this);
                for (String s : this.opsAndMultiplier.keySet()) {
                    TwoIntegers ti = this.opsAndMultiplier.get(s);
                    AELog.crafting(s + " * " + 0L + " = " + 0L * 0L, new Object[0]);
                }
                if (this.actionSrc.player().isPresent()) {
                    this.logCraftingJob("simulated, success", this.craftingTreeWatch);
                } else {
                    this.logCraftingJob("real, success", this.craftingTreeWatch);
                }
            }
            catch (CraftBranchFailure e) {
                this.simulate = true;
                try {
                    if (this.actionSrc.player().isPresent()) {
                        MECraftingInventory craftingInventory = new MECraftingInventory(this.original, true, false, true);
                        craftingInventory.ignore(this.output);
                        this.getTree().setSimulate();
                        this.availableCheck = new MECraftingInventory(this.original, false, false, false);
                        this.craftingTreeWatch.reset().start();
                        this.getTree().request(craftingInventory, this.output.getStackSize(), this.actionSrc);
                        this.craftingTreeWatch.stop();
                        this.getTree().dive(this);
                        for (String s : this.opsAndMultiplier.keySet()) {
                            TwoIntegers ti = this.opsAndMultiplier.get(s);
                            AELog.crafting(s + " * " + 0L + " = " + 0L * 0L, new Object[0]);
                        }
                        this.logCraftingJob("simulated, failed", this.craftingTreeWatch);
                    } else {
                        this.logCraftingJob("real, failed", this.craftingTreeWatch);
                    }
                }
                catch (CraftBranchFailure | CraftingCalculationFailure e1) {
                    AELog.debug(e1);
                }
                catch (InterruptedException e1) {
                    AELog.crafting("Crafting calculation canceled.", new Object[0]);
                    this.finish();
                    return;
                }
            }
            catch (CraftingCalculationFailure f) {
                AELog.debug(f);
            }
            catch (InterruptedException e1) {
                AELog.crafting("Crafting calculation canceled.", new Object[0]);
                this.finish();
                return;
            }
            AELog.craftingDebug("crafting job now done", new Object[0]);
        }
        catch (Throwable t) {
            this.finish();
            throw new IllegalStateException(t);
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePausing() throws InterruptedException {
        if (!this.actionSrc.player().isPresent() && this.incTime > 100) {
            this.incTime = 0;
            Object object = this.monitor;
            synchronized (object) {
                if (this.tickSpreadingWatch.elapsed(TimeUnit.MICROSECONDS) > (long)this.time) {
                    this.running = false;
                    if (this.craftingTreeWatch.isRunning()) {
                        this.craftingTreeWatch.stop();
                    }
                    if (this.tickSpreadingWatch.isRunning()) {
                        this.tickSpreadingWatch.stop();
                    }
                    this.monitor.notify();
                }
                if (!this.running) {
                    AELog.craftingDebug("crafting job will now sleep", new Object[0]);
                    while (!this.running) {
                        this.monitor.wait();
                    }
                    AELog.craftingDebug("crafting job now active", new Object[0]);
                }
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ++this.incTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        if (this.callback != null) {
            this.callback.calculationComplete(this);
        }
        this.availableCheck = null;
        Object object = this.monitor;
        synchronized (object) {
            this.running = false;
            this.done = true;
            this.monitor.notify();
        }
    }

    @Override
    public boolean isSimulation() {
        return this.simulate;
    }

    @Override
    public long getByteTotal() {
        return this.bytes;
    }

    @Override
    public void populatePlan(IItemList<IAEItemStack> plan) {
        if (this.getTree() != null) {
            this.getTree().getPlan(plan);
        }
    }

    @Override
    public IAEItemStack getOutput() {
        return this.output;
    }

    public boolean isDone() {
        return this.done;
    }

    World getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean simulateFor(int milli) {
        this.time = milli;
        Object object = this.monitor;
        synchronized (object) {
            if (this.done) {
                return false;
            }
            if (!this.actionSrc.player().isPresent()) {
                this.tickSpreadingWatch.reset();
                this.tickSpreadingWatch.start();
                this.monitor.notify();
            }
            this.running = true;
        }
        return true;
    }

    void addBytes(long crafts) {
        this.bytes += crafts;
    }

    public CraftingTreeNode getTree() {
        return this.tree;
    }

    private void setTree(CraftingTreeNode tree) {
        this.tree = tree;
    }

    private void logCraftingJob(String type, Stopwatch timer) {
        if (AELog.isCraftingLogEnabled()) {
            String actionSource;
            String itemToOutput = this.output.toString();
            long elapsedTime = timer.elapsed(TimeUnit.MICROSECONDS);
            if (this.actionSrc.player().isPresent()) {
                EntityPlayer player = this.actionSrc.player().get();
                actionSource = player.toString();
            } else if (this.actionSrc.machine().isPresent()) {
                IActionHost machineSource = this.actionSrc.machine().get();
                IGridNode actionableNode = machineSource.getActionableNode();
                IGridHost machine = actionableNode.getMachine();
                DimensionalCoord location = actionableNode.getGridBlock().getLocation();
                actionSource = String.format(LOG_MACHINE_SOURCE_DETAILS, machine, location);
            } else {
                actionSource = "[unknown source]";
            }
            AELog.crafting(LOG_CRAFTING_JOB, type, actionSource, itemToOutput, this.bytes, elapsedTime);
        }
    }

    private static class TwoIntegers {
        private final long perOp = 0L;
        private final long times = 0L;

        private TwoIntegers() {
        }
    }
}

