/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.items.IItemHandler;

public class PacketPatternSlot
extends AppEngPacket {
    public final IAEItemStack slotItem;
    public final IAEItemStack[] pattern = new IAEItemStack[9];
    public final boolean shift;

    public PacketPatternSlot(ByteBuf stream) throws IOException {
        this.shift = stream.readBoolean();
        this.slotItem = this.readItem(stream);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = this.readItem(stream);
        }
    }

    private IAEItemStack readItem(ByteBuf stream) throws IOException {
        boolean hasItem = stream.readBoolean();
        if (hasItem) {
            return AEItemStack.fromPacket(stream);
        }
        return null;
    }

    public PacketPatternSlot(IItemHandler pat, IAEItemStack slotItem, boolean shift) throws IOException {
        this.slotItem = slotItem;
        this.shift = shift;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        this.writeItem(slotItem, data);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = (IAEItemStack)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(pat.getStackInSlot(x));
            this.writeItem(this.pattern[x], data);
        }
        this.configureWrite(data);
    }

    private void writeItem(IAEItemStack slotItem, ByteBuf data) throws IOException {
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        if (sender.field_71070_bA instanceof ContainerPatternEncoder) {
            ContainerPatternEncoder patternEncoder = (ContainerPatternEncoder)sender.field_71070_bA;
            patternEncoder.craftOrGetItem(this);
        }
    }
}

