/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.toasts.CraftingStatusToast;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCraftingToast
extends AppEngPacket {
    private final IAEItemStack stack;
    private final boolean cancelled;

    public PacketCraftingToast(ByteBuf stream) {
        this.stack = AEItemStack.fromPacket(stream);
        this.cancelled = stream.readBoolean();
    }

    public PacketCraftingToast(IAEItemStack stack, boolean cancelled) throws IOException {
        this.stack = stack;
        this.cancelled = cancelled;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        stack.writeToPacket(data);
        data.writeBoolean(cancelled);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CRAFTING_TOASTS)) {
            this.doCraftingToast();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doCraftingToast() {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new CraftingStatusToast(this.stack.asItemStackRepresentation(), this.cancelled));
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
    }
}

