/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class TesrRenderHelper {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;

    public static void moveToFace(EnumFacing face) {
        GlStateManager.func_179137_b((double)((double)face.func_82601_c() * 0.5), (double)((double)face.func_96559_d() * 0.5), (double)((double)face.func_82599_e() * 0.5));
    }

    public static void rotateToFace(EnumFacing face, byte spin) {
        switch (face) {
            case UP: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    public static void renderItem2d(ItemStack itemStack, float scale) {
        if (!itemStack.func_190926_b()) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(scale / 32.0f), (float)(scale / 32.0f), (float)1.0E-4f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-11.0f, (float)0.0f);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            renderItem.func_180450_b(itemStack, 0, 0);
            GlStateManager.func_179121_F();
        }
    }

    public static void renderFluid2d(FluidStack fluidStack, float scale) {
        if (fluidStack != null) {
            GlStateManager.func_179094_E();
            int color = fluidStack.getFluid().getColor(fluidStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179118_c();
            GlStateManager.func_179140_f();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            float width = 0.4f;
            float height = 0.4f;
            float alpha = 1.0f;
            float z = 1.0E-4f;
            float x = -0.2f;
            float y = -0.25f;
            buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double uMin = sprite.func_94214_a(16.0 - (double)width * 16.0);
            double uMax = sprite.func_94214_a((double)width * 16.0);
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94207_b((double)height * 16.0);
            buf.func_181662_b((double)x, (double)y, (double)z).func_187315_a(uMin, vMin).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(uMin, vMax).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(uMax, vMax).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(uMax, vMin).func_181666_a(r, g, b, alpha).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void renderItem2dWithAmount(IAEItemStack itemStack, float itemScale, float spacing) {
        ItemStack renderStack = itemStack.asItemStackRepresentation();
        TesrRenderHelper.renderItem2d(renderStack, itemScale);
        long stackSize = itemStack.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GlStateManager.func_179109_b((float)0.0f, (float)spacing, (float)0.0f);
        GlStateManager.func_179152_a((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        GlStateManager.func_179109_b((float)(-0.5f * (float)width), (float)0.0f, (float)0.5f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
    }

    public static void renderFluid2dWithAmount(IAEFluidStack fluidStack, float scale, float spacing) {
        FluidStack renderStack = fluidStack.getFluidStack();
        TesrRenderHelper.renderFluid2d(renderStack, scale);
        long stackSize = fluidStack.getStackSize() / 1000L;
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize) + "B";
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GlStateManager.func_179109_b((float)0.0f, (float)spacing, (float)0.0f);
        GlStateManager.func_179152_a((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        GlStateManager.func_179109_b((float)(-0.5f * (float)width), (float)0.0f, (float)0.5f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
    }
}

