/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerInterfaceConfigurationTerminal;
import appeng.container.interfaces.IJEIGhostIngredients;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.helpers.ItemStackHelper;
import appeng.parts.reporting.PartInterfaceConfigurationTerminal;
import appeng.util.BlockPosUtils;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.HashMultimap;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiInterfaceConfigurationTerminal
extends AEBaseGui
implements IJEIGhostIngredients {
    private static final int LINES_ON_PAGE = 6;
    private final int offsetX = 21;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalInv, BlockPos> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap = new HashMap();
    private final Map<ClientDCInternalInv, Integer> numUpgradesMap = new HashMap<ClientDCInternalInv, Integer>();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Set<ClientDCInternalInv> matchedInterfaces = new HashSet<ClientDCInternalInv>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private MEGuiTextField searchFieldInputs;
    private final PartInterfaceConfigurationTerminal partInterfaceTerminal;
    private final HashMap<ClientDCInternalInv, Integer> dimHashMap = new HashMap();
    public Map<IGhostIngredientHandler.Target<?>, Object> mapTargetSlot = new HashMap();

    public GuiInterfaceConfigurationTerminal(InventoryPlayer inventoryPlayer, PartInterfaceConfigurationTerminal te) {
        super(new ContainerInterfaceConfigurationTerminal(inventoryPlayer, te));
        this.partInterfaceTerminal = te;
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 208;
        this.field_147000_g = 235;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.getScrollBar().setLeft(189);
        this.getScrollBar().setHeight(106);
        this.getScrollBar().setTop(31);
        this.searchFieldInputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, this.offsetX), this.field_147009_r + 17, 65, 12);
        this.searchFieldInputs.func_146185_a(false);
        this.searchFieldInputs.func_146203_f(25);
        this.searchFieldInputs.func_146193_g(0xFFFFFF);
        this.searchFieldInputs.func_146189_e(true);
        this.searchFieldInputs.func_146195_b(false);
        this.searchFieldInputs.func_146180_a(this.partInterfaceTerminal.in);
    }

    @Override
    public void func_146281_b() {
        this.partInterfaceTerminal.saveSearchStrings(this.searchFieldInputs.func_146179_b().toLowerCase());
        super.func_146281_b();
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146292_n.clear();
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceConfigurationTerminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), this.offsetX + 2, this.field_147000_g - 96 + 3, 0x404040);
        int currentScroll = this.getScrollBar().getCurrentScroll();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        int offset = 30;
        int linesDraw = 0;
        for (int x = 0; x < 6 && linesDraw < 6 && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put(guiButton, inv);
                this.field_146292_n.add(guiButton);
                int extraLines = this.numUpgradesMap.get(inv);
                for (int row = 0; row < 1 + extraLines && linesDraw < 6; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z + row * 9, z * 18 + 22, offset));
                        if (this.matchedStacks.contains(inv.getInventory().getStackInSlot(z + row * 9))) {
                            GuiInterfaceConfigurationTerminal.func_73734_a((int)(z * 18 + 22), (int)offset, (int)(z * 18 + 22 + 16), (int)(offset + 16), (int)-1979646208);
                            continue;
                        }
                        if (this.matchedInterfaces.contains(inv)) continue;
                        GuiInterfaceConfigurationTerminal.func_73734_a((int)(z * 18 + 22), (int)offset, (int)(z * 18 + 22 + 16), (int)(offset + 16), (int)0x6A000000);
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 155) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, this.offsetX + 2, 5 + offset, 0x404040);
            ++linesDraw;
            offset += 18;
        }
        if (this.searchFieldInputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, "Inputs OR names");
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        this.searchFieldInputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldInputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldInputs.func_146180_a("");
            this.refreshList();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        if (this.guiButtonHashMap.containsKey(btn)) {
            int interfaceDim;
            BlockPos blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(this.field_146290_a));
            BlockPos blockPos2 = this.field_146297_k.field_71439_g.func_180425_c();
            int playerDim = this.field_146297_k.field_71441_e.field_73011_w.getDimension();
            if (playerDim != (interfaceDim = this.dimHashMap.get(this.guiButtonHashMap.get(this.field_146290_a)).intValue())) {
                try {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Interface located at dimension: " + interfaceDim + " [" + DimensionManager.getWorld((int)interfaceDim).field_73011_w.func_186058_p().func_186065_b() + "] and cant be highlighted"), false);
                }
                catch (Exception e) {
                    this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Interface is located in another dimension and cannot be highlighted"), false);
                }
            } else {
                BlockPosHighlighter.hilightBlock(blockPos, System.currentTimeMillis() + 500L * BlockPosUtils.getDistance(blockPos, blockPos2), playerDim);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("The interface is now highlighted at X: " + blockPos.func_177958_n() + " Y: " + blockPos.func_177956_o() + " Z: " + blockPos.func_177952_p()), false);
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Override
    protected void mouseWheelEvent(int x, int y, int wheel) {
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotDisconnected) {
            ItemStack stack = slot.func_75211_c();
            if (stack != ItemStack.field_190927_a) {
                PacketInventoryAction p;
                if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                    InventoryAction direction = wheel > 0 ? InventoryAction.DOUBLE : InventoryAction.HALVE;
                    p = new PacketInventoryAction(direction, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                } else {
                    InventoryAction direction = wheel > 0 ? InventoryAction.PLACE_SINGLE : InventoryAction.PICKUP_SINGLE;
                    p = new PacketInventoryAction(direction, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                }
                NetworkHandler.instance().sendToServer(p);
            }
        } else {
            super.mouseWheelEvent(x, y, wheel);
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/interfaceconfigurationterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        int offset = 29;
        int ex = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < 6 && linesDraw < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = 162;
                int extraLines = this.numUpgradesMap.get(lineObj);
                for (int row = 0; row < 1 + extraLines && linesDraw < 6; ++linesDraw, ++row) {
                    this.func_73729_b(offsetX + 20, offsetY + offset, 20, 170, 162, 18);
                    offset += 18;
                }
                continue;
            }
            offset += 18;
            ++linesDraw;
        }
        if (this.searchFieldInputs != null) {
            this.searchFieldInputs.func_146194_f();
        }
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchFieldInputs.func_146179_b().isEmpty() && this.searchFieldInputs.func_146206_l()) {
                return;
            }
            if (this.searchFieldInputs.func_146201_a(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                this.blockPosHashMap.put(current, NBTUtil.func_186861_c((NBTTagCompound)invData.func_74775_l("pos")));
                this.dimHashMap.put(current, invData.func_74762_e("dim"));
                this.numUpgradesMap.put(current, invData.func_74762_e("numUpgrades"));
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, ItemStackHelper.stackFromNBT(invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        this.matchedInterfaces.clear();
        String searchFieldInputs = this.searchFieldInputs.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFieldInputs);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty();
            if (!found) {
                int slot = 0;
                for (ItemStack itemStack : entry.getInventory()) {
                    if (slot > 8 + this.numUpgradesMap.get(entry) * 9) break;
                    if (this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs)) {
                        found = true;
                        this.matchedStacks.add(itemStack);
                    }
                    ++slot;
                }
            }
            if (searchFieldInputs.isEmpty() || entry.getName().toLowerCase().contains(searchFieldInputs)) {
                this.matchedInterfaces.add(entry);
                found = true;
            }
            if (found) {
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList();
            clientInventories.addAll(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 1, 1);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean foundMatchingItemStack = false;
        String displayName = Platform.getItemDisplayName(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(itemStack)).toLowerCase();
        for (String term : searchTerm.split(" ")) {
            if (term.length() > 1 && (term.startsWith("-") || term.startsWith("!"))) {
                if (!displayName.contains(term = term.substring(1))) continue;
                return false;
            }
            if (displayName.contains(term)) {
                foundMatchingItemStack = true;
                continue;
            }
            return false;
        }
        return foundMatchingItemStack;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, string, 512);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        for (final Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof SlotDisconnected)) continue;
            final ItemStack itemStack = (ItemStack)ingredient;
            IGhostIngredientHandler.Target<Object> target = new IGhostIngredientHandler.Target<Object>(){

                public Rectangle getArea() {
                    return new Rectangle(GuiInterfaceConfigurationTerminal.this.getGuiLeft() + slot.field_75223_e, GuiInterfaceConfigurationTerminal.this.getGuiTop() + slot.field_75221_f, 16, 16);
                }

                public void accept(Object ingredient) {
                    try {
                        PacketInventoryAction p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (SlotDisconnected)slot, (IAEItemStack)AEItemStack.fromItemStack(itemStack));
                        NetworkHandler.instance().sendToServer(p);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            targets.add(target);
            this.mapTargetSlot.putIfAbsent(target, slot);
        }
        return targets;
    }

    @Override
    public Map<IGhostIngredientHandler.Target<?>, Object> getFakeSlotTargetMap() {
        return IJEIGhostIngredients.super.getFakeSlotTargetMap();
    }
}

