/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.immersiveengineering;

import hellfall.visualores.database.immersiveengineering.ExcavatorVeinPosition;
import hellfall.visualores.database.immersiveengineering.IEClientCache;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.ChunkPos;

public class ExcavatorRenderLayer
extends RenderLayer {
    private List<ExcavatorVeinPosition> visibleVeins = new ArrayList<ExcavatorVeinPosition>();
    private ExcavatorVeinPosition hoveredVein;
    private static ExcavatorVeinPosition waypointVein;

    public ExcavatorRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        for (ExcavatorVeinPosition vein : this.visibleVeins) {
            int sideColor = vein.color & 0xDDFFFFFF;
            if (vein == waypointVein) {
                sideColor = -10496;
            }
            DrawUtils.drawOverlayBox(vein.x, vein.z, sideColor, vein.color & 0x77FFFFFF);
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleVeins = IEClientCache.instance.getVeinsInArea(dimensionID, visibleBounds);
    }

    @Override
    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        ChunkPos mousePos = new ChunkPos(DrawUtils.getMouseBlockPos(mouseX, mouseY, cameraX, cameraZ, scale));
        this.hoveredVein = null;
        for (ExcavatorVeinPosition vein : this.visibleVeins) {
            if (vein.x != mousePos.field_77276_a || vein.z != mousePos.field_77275_b) continue;
            this.hoveredVein = vein;
            break;
        }
    }

    @Override
    public List<String> getTooltip() {
        if (this.hoveredVein != null) {
            return this.hoveredVein.getTooltip();
        }
        return null;
    }

    @Override
    public boolean onDoubleClick() {
        if (this.hoveredVein == null) {
            return false;
        }
        waypointVein = this.toggleWaypoint(this.hoveredVein.getTooltip().get(0), 0xFFFFFF, null, this.hoveredVein.x * 16 + 8, 64, this.hoveredVein.z * 16 + 8) ? this.hoveredVein : null;
        return true;
    }
}

