/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.astralsorcery;

import hellfall.visualores.database.astralsorcery.ASClientCache;
import hellfall.visualores.database.astralsorcery.NeromanticPosition;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.ChunkPos;

public class NeromanticRenderLayer
extends RenderLayer {
    private List<NeromanticPosition> visibleChunks = new ArrayList<NeromanticPosition>();
    private NeromanticPosition hoveredChunk;

    public NeromanticRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        for (NeromanticPosition vein : this.visibleChunks) {
            int sideColor = (vein.color & 0xFFFFFF) + -587202560;
            int midColor = (vein.color & 0xFFFFFF) + 0x77000000;
            DrawUtils.drawOverlayBox(vein.x, vein.z, sideColor, midColor);
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleChunks = ASClientCache.instance.getNeromanticVeinsInBounds(dimensionID, visibleBounds);
    }

    @Override
    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        ChunkPos mousePos = new ChunkPos(DrawUtils.getMouseBlockPos(mouseX, mouseY, cameraX, cameraZ, scale));
        this.hoveredChunk = null;
        for (NeromanticPosition vein : this.visibleChunks) {
            if (vein.x != mousePos.field_77276_a || vein.z != mousePos.field_77275_b) continue;
            this.hoveredChunk = vein;
            break;
        }
    }

    @Override
    public List<String> getTooltip() {
        if (this.hoveredChunk != null) {
            return this.hoveredChunk.tooltip;
        }
        return null;
    }
}

