/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map;

import hellfall.visualores.VOConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ButtonState {
    private static final Map<String, Button> buttons = new HashMap<String, Button>();
    private static List<Button> sortedButtons;
    private static List<Button> reverseSortedButtons;

    public static void toggleButton(Button button) {
        boolean bl = button.enabled = !button.enabled;
        if (!VOConfig.client.allowMultipleLayers && button.enabled) {
            for (String name : buttons.keySet()) {
                if (name.equals(button.name)) continue;
                ButtonState.buttons.get((Object)name).enabled = false;
            }
        }
    }

    public static void toggleButton(String buttonName) {
        ButtonState.toggleButton(buttons.get(buttonName));
    }

    public static boolean isEnabled(Button button) {
        return button.enabled;
    }

    public static boolean isEnabled(String buttonName) {
        return ButtonState.buttons.get((Object)buttonName).enabled;
    }

    public static int buttonAmount() {
        return buttons.size();
    }

    public static List<Button> getAllButtons() {
        if (sortedButtons == null) {
            sortedButtons = buttons.values().stream().sorted(Comparator.comparingInt(b -> Arrays.asList(VOConfig.client.buttonOrder).indexOf(b.name))).collect(Collectors.toList());
            reverseSortedButtons = new ArrayList<Button>(sortedButtons);
            Collections.reverse(reverseSortedButtons);
        }
        return VOConfig.client.reverseButtonOrder ? reverseSortedButtons : sortedButtons;
    }

    public static class Button {
        public boolean enabled = false;
        public final String name;

        public Button(String name) {
            this.name = name;
        }

        public static void makeButton(String name) {
            buttons.put(name, new Button(name));
        }
    }
}

