/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.thaumcraft;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class AuraFluxPosition {
    private static final float[] BASE_FLUX_HSB = Color.RGBtoHSB(111, 22, 124, null);
    private static final DecimalFormat format = new DecimalFormat("#######.#");
    public int x;
    public int z;
    public short base;
    public float aura;
    public float flux;
    public int color;
    public int midColor;
    public List<String> tooltips;

    public AuraFluxPosition(short base, float aura, float flux, int x, int z) {
        this.base = base;
        this.aura = aura;
        this.flux = flux;
        this.x = x;
        this.z = z;
        double totalAmount = (aura + flux) / (float)base;
        float fluxAmount = flux / (aura + flux);
        int alpha = (int)Math.min(255.0, Math.floor(totalAmount * 200.0));
        int midAlpha = (int)Math.min(119.0, Math.floor(totalAmount * 100.0));
        int colorBase = Color.HSBtoRGB(BASE_FLUX_HSB[0], BASE_FLUX_HSB[1] * fluxAmount, 1.0f + (BASE_FLUX_HSB[2] - 1.0f) * fluxAmount);
        this.color = (alpha << 24) + colorBase;
        this.midColor = (midAlpha << 24) + colorBase;
        this.tooltips = new ArrayList<String>(3);
        this.tooltips.add(I18n.func_135052_a((String)"visualores.thaumcraft.aura", (Object[])new Object[]{format.format(aura)}));
        this.tooltips.add(I18n.func_135052_a((String)"visualores.thaumcraft.flux", (Object[])new Object[]{format.format(flux)}));
        this.tooltips.add(I18n.func_135052_a((String)"visualores.thaumcraft.base", (Object[])new Object[]{format.format(aura + flux), base}));
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74777_a("base", this.base);
        result.func_74776_a("aura", this.aura);
        result.func_74776_a("flux", this.flux);
        return result;
    }
}

