/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.immersiveengineering;

import hellfall.visualores.database.immersiveengineering.ExcavatorVeinPosition;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class IEDimensionCache {
    private final Object2ObjectMap<ChunkPos, ExcavatorVeinPosition> chunks = new Object2ObjectOpenHashMap();

    public void addVein(ItemStack stack, NBTTagCompound nbt) {
        int[] coords = nbt.func_74759_k("coords");
        ChunkPos key = new ChunkPos(coords[1], coords[2]);
        this.chunks.put((Object)key, (Object)new ExcavatorVeinPosition(stack, nbt));
    }

    public List<ExcavatorVeinPosition> getVeinsInArea(ChunkPos topLeft, ChunkPos bottomRight) {
        ArrayList<ExcavatorVeinPosition> result = new ArrayList<ExcavatorVeinPosition>();
        for (int i = topLeft.field_77276_a; i <= bottomRight.field_77276_a; ++i) {
            for (int j = topLeft.field_77275_b; j <= bottomRight.field_77275_b; ++j) {
                ChunkPos pos = new ChunkPos(i, j);
                if (!this.chunks.containsKey((Object)pos)) continue;
                result.add((ExcavatorVeinPosition)this.chunks.get((Object)pos));
            }
        }
        return result;
    }

    public void fromNBT(NBTTagCompound nbt) {
        for (String nbtKey : nbt.func_150296_c()) {
            String[] splitpos = nbtKey.split(",");
            ChunkPos key = new ChunkPos(Integer.parseInt(splitpos[0]), Integer.parseInt(splitpos[1]));
            this.chunks.put((Object)key, (Object)new ExcavatorVeinPosition(null, nbt.func_74775_l(nbtKey)));
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        for (ChunkPos key : this.chunks.keySet()) {
            result.func_74782_a(key.field_77276_a + "," + key.field_77275_b, (NBTBase)((ExcavatorVeinPosition)this.chunks.get((Object)key)).toNBT());
        }
        return result;
    }
}

