/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.immersiveengineering;

import blusunrize.immersiveengineering.common.IEContent;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.EventHandler;
import hellfall.visualores.map.DrawUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;

public class ExcavatorVeinPosition {
    public int x;
    public int z;
    public int dim;
    public String mineral;
    public Integer depletion;
    public boolean infinite;
    public long timestamp;
    public String resType;
    public Integer oil;
    public int color;
    private List<String> tooltip;
    private ItemStack cachedStack;

    public ExcavatorVeinPosition(@Nullable ItemStack stack, NBTTagCompound nbt) {
        if (stack == null) {
            stack = new ItemStack((Item)IEContent.itemCoresample);
            stack.func_77982_d(nbt);
        }
        this.cachedStack = stack;
        this.color = -1;
        int[] coords = nbt.func_74759_k("coords");
        this.x = coords[1];
        this.z = coords[2];
        this.dim = coords[0];
        this.timestamp = nbt.func_74763_f("timestamp");
        if (nbt.func_74764_b("mineral")) {
            this.mineral = nbt.func_74779_i("mineral");
        }
        if (nbt.func_74764_b("depletion")) {
            this.depletion = nbt.func_74762_e("depletion");
        }
        if (nbt.func_74764_b("infinite")) {
            this.infinite = nbt.func_74767_n("infinite");
        }
        if (nbt.func_74764_b("resType")) {
            this.resType = nbt.func_74779_i("resType");
            if (Loader.isModLoaded((String)"immersivepetroleum")) {
                this.color = DrawUtils.getFluidColor(this.getIPFluid(this.resType));
            }
        }
        if (nbt.func_74764_b("oil")) {
            this.oil = nbt.func_74762_e("oil");
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74772_a("timestamp", this.timestamp);
        result.func_74783_a("coords", new int[]{this.dim, this.x, this.z});
        if (this.mineral != null) {
            result.func_74778_a("mineral", this.mineral);
        }
        if (this.depletion != null) {
            result.func_74768_a("depletion", this.depletion.intValue());
        }
        if (this.infinite) {
            result.func_74757_a("infinite", true);
        }
        if (this.resType != null) {
            result.func_74778_a("resType", this.resType);
        }
        if (this.oil != null) {
            result.func_74768_a("oil", this.oil.intValue());
        }
        return result;
    }

    public List<String> getTooltip() {
        if (this.tooltip == null) {
            this.tooltip = new ArrayList<String>();
            this.cachedStack.func_77973_b().func_77624_a(this.cachedStack, null, this.tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            if (Loader.isModLoaded((String)"immersivepetroleum")) {
                this.addIPInfo(this.cachedStack, this.tooltip);
            }
            this.cachedStack = null;
        }
        return this.tooltip;
    }

    private void addIPInfo(ItemStack stack, List<String> tooltip) {
        EventHandler.handleItemTooltip((ItemTooltipEvent)new ItemTooltipEvent(stack, null, tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
    }

    private Fluid getIPFluid(String name) {
        for (PumpjackHandler.ReservoirType type : PumpjackHandler.reservoirList.keySet()) {
            if (!name.equals(type.name)) continue;
            return type.getFluid();
        }
        return null;
    }
}

