/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import hellfall.visualores.database.gregtech.ore.OreVeinInfo;
import java.util.HashMap;
import java.util.Map;

public class VeinInfoCache {
    private static Map<String, OreVeinInfo> cache;

    public static void init() {
        cache = new HashMap<String, OreVeinInfo>();
        for (OreDepositDefinition def : WorldGenRegistry.getOreDeposits()) {
            if (!def.isVein()) continue;
            cache.put(def.getDepositName(), new OreVeinInfo(def));
        }
    }

    public static OreVeinInfo getByName(String name) {
        if (!cache.containsKey(name)) {
            cache.put(name, OreVeinInfo.missingVein(name));
        }
        return cache.get(name);
    }

    public static OreDepositDefinition getDefinitionByName(String name) {
        for (OreDepositDefinition def : WorldGenRegistry.getOreDeposits()) {
            if (!def.getDepositName().equals(name)) continue;
            return def;
        }
        return null;
    }
}

