/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import hellfall.visualores.VOConfig;
import hellfall.visualores.database.gregtech.ore.DimensionCache;
import hellfall.visualores.database.gregtech.ore.OreCacheRetrogenerator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class ServerCacheSaveData
extends WorldSavedData {
    private static final String DATA_NAME = "visualores";
    private DimensionCache backingCache;
    private NBTTagCompound toRead;

    public ServerCacheSaveData(String name) {
        super(name);
    }

    public ServerCacheSaveData() {
        super(DATA_NAME);
    }

    public static ServerCacheSaveData init(World world, DimensionCache backingCache) {
        MapStorage storage = world.getPerWorldStorage();
        ServerCacheSaveData instance = (ServerCacheSaveData)storage.func_75742_a(ServerCacheSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new ServerCacheSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            if (VOConfig.server.gregtech.doRetrogen) {
                OreCacheRetrogenerator.doRetrogen(world);
            }
            instance.func_76185_a();
        }
        instance.backingCache = backingCache;
        if (backingCache.dirty) {
            instance.func_76185_a();
        }
        if (instance.toRead != null) {
            backingCache.fromNBT(instance.toRead);
            instance.toRead = null;
        }
        return instance;
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        if (this.backingCache != null) {
            this.backingCache.fromNBT(nbt);
        } else {
            this.toRead = nbt;
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        return this.backingCache.toNBT(compound);
    }
}

