/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import codechicken.lib.texture.TextureUtils;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GregFakePlayer;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.world.DummyWorld;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.filler.FillerEntry;
import gregtech.api.worldgen.filler.LayeredBlockFiller;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import gregtech.common.blocks.BlockOre;
import hellfall.visualores.VOConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class OreVeinInfo {
    public Material surfaceRockMaterial;
    public Set<String> oreMaterialStrings = new HashSet<String>();
    public ResourceLocation texture;
    public int color;
    public TextureAtlasSprite tas;
    public List<String> tooltipStrings;

    public OreVeinInfo(OreDepositDefinition def) {
        if (def.getVeinPopulator() instanceof SurfaceRockPopulator) {
            this.surfaceRockMaterial = ((SurfaceRockPopulator)def.getVeinPopulator()).getMaterial();
        }
        for (FillerEntry filler : OreVeinInfo.getAllFillers(def.getBlockFiller())) {
            for (IBlockState blockState : filler.getPossibleResults()) {
                String name = OreVeinInfo.getBaseMaterialName(blockState);
                if (name.isEmpty()) continue;
                this.oreMaterialStrings.add(name);
            }
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            Collection possiblePrimaryStates = def.getBlockFiller() instanceof LayeredBlockFiller ? ((LayeredBlockFiller)def.getBlockFiller()).getPrimary().getPossibleResults() : OreVeinInfo.getAllRelevantStates(def.getBlockFiller());
            for (IBlockState state : possiblePrimaryStates) {
                if (state.func_177230_c() instanceof BlockOre) {
                    Material mat = ((BlockOre)state.func_177230_c()).field_149764_J;
                    ResourceLocation shortenedLocation = MaterialIconType.ore.getBlockTexturePath(mat.getMaterialIconSet());
                    this.texture = new ResourceLocation(shortenedLocation.func_110624_b(), "textures/" + shortenedLocation.func_110623_a() + ".png");
                    this.color = mat.getMaterialRGB();
                    break;
                }
                this.tas = TextureUtils.getSideIconsForBlock((IBlockState)state)[EnumFacing.NORTH.ordinal()];
                if (this.tas == TextureUtils.getMissingSprite()) continue;
                break;
            }
            this.tooltipStrings = new ArrayList<String>();
            if (def.getAssignedName() != null) {
                this.tooltipStrings.add(def.getAssignedName());
            } else {
                this.tooltipStrings.add(FileUtility.trimFileName((String)def.getDepositName()));
            }
            for (IBlockState state : OreVeinInfo.getAllRelevantStates(def.getBlockFiller())) {
                String matName = OreVeinInfo.getBaseMaterialName(state);
                if (!matName.isEmpty() && state.func_177230_c() instanceof BlockOre) {
                    this.tooltipStrings.add(VOConfig.client.gregtech.oreNamePrefix + LocalizationUtils.format((String)"item.material.oreprefix.ore", (Object[])new Object[]{GregTechAPI.materialManager.getMaterial(matName).getLocalizedName()}));
                    continue;
                }
                ItemStack stack = OreVeinInfo.getStackFromState(state);
                if (!stack.func_190926_b()) {
                    this.tooltipStrings.add(VOConfig.client.gregtech.oreNamePrefix + stack.func_82833_r());
                    continue;
                }
                this.tooltipStrings.add(VOConfig.client.gregtech.oreNamePrefix + state.func_177230_c().func_149732_F());
            }
        }
    }

    private OreVeinInfo(String missingName) {
        this.color = 0xFF00FF;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.tooltipStrings = new ArrayList<String>();
            this.tooltipStrings.add(I18n.func_135052_a((String)"visualores.gregtech.missingvein", (Object[])new Object[]{missingName}));
        }
    }

    public static OreVeinInfo missingVein(String name) {
        return new OreVeinInfo(name);
    }

    public static String getBaseMaterialName(IBlockState state) {
        MaterialStack stack = OreDictUnifier.getMaterial((ItemStack)GTUtility.toItem((IBlockState)state));
        if (stack == null) {
            return "";
        }
        return stack.material.getResourceLocation().toString();
    }

    public static Material getMaterial(IBlockState state) {
        MaterialStack stack = OreDictUnifier.getMaterial((ItemStack)GTUtility.toItem((IBlockState)state));
        if (stack == null) {
            return Materials.NULL;
        }
        return stack.material;
    }

    private static FillerEntry[] getAllFillers(BlockFiller filler) {
        if (filler instanceof LayeredBlockFiller) {
            LayeredBlockFiller layeredFiller = (LayeredBlockFiller)filler;
            return new FillerEntry[]{layeredFiller.getPrimary(), layeredFiller.getSecondary(), layeredFiller.getBetween(), layeredFiller.getSporadic()};
        }
        return filler.getAllPossibleStates().toArray(new FillerEntry[0]);
    }

    private static Collection<IBlockState> getAllRelevantStates(BlockFiller filler) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        if (filler instanceof LayeredBlockFiller) {
            for (FillerEntry entry : OreVeinInfo.getAllFillers(filler)) {
                states.add((IBlockState)entry.getPossibleResults().toArray()[0]);
            }
        } else {
            FillerEntry entry = (FillerEntry)filler.getAllPossibleStates().get(0);
            HashSet<Material> seenMaterials = new HashSet<Material>();
            for (IBlockState state : entry.getPossibleResults()) {
                Block block = state.func_177230_c();
                if (block instanceof BlockOre) {
                    BlockOre blockOre = (BlockOre)block;
                    if (seenMaterials.contains(blockOre.field_149764_J)) continue;
                    seenMaterials.add(blockOre.field_149764_J);
                    states.add(state);
                    continue;
                }
                states.add(state);
            }
        }
        return states;
    }

    private static ItemStack getStackFromState(IBlockState state) {
        ItemStack stack = ItemStack.field_190927_a;
        BlockPos pos = new BlockPos(0, 0, 0);
        if (stack.func_190926_b()) {
            stack = GTUtility.toItem((IBlockState)state);
        }
        if (stack.func_190926_b()) {
            ItemStack is;
            NonNullList list = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(list, (IBlockAccess)DummyWorld.INSTANCE, pos, state, 0);
            if (!list.isEmpty() && !(is = (ItemStack)list.get(0)).func_190926_b()) {
                stack = is;
            }
        }
        if (stack.func_190926_b()) {
            stack = state.func_177230_c().getPickBlock(state, new RayTraceResult(Vec3d.field_186680_a, EnumFacing.UP, pos), (World)DummyWorld.INSTANCE, pos, (EntityPlayer)new GregFakePlayer((World)DummyWorld.INSTANCE));
        }
        return stack;
    }
}

