/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import java.util.Objects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class GridPos {
    public int x;
    public int z;

    public GridPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public GridPos(ChunkPos chunk) {
        this.x = Math.floorDiv(chunk.field_77276_a, 3);
        this.z = Math.floorDiv(chunk.field_77275_b, 3);
    }

    public GridPos(BlockPos block) {
        this.x = Math.floorDiv(block.func_177958_n() >> 4, 3);
        this.z = Math.floorDiv(block.func_177952_p() >> 4, 3);
    }

    public ChunkPos getChunk(int x, int z) {
        return new ChunkPos(this.x * 3 + x, this.z * 3 + z);
    }

    public BlockPos getBlock(int x, int y, int z) {
        return new BlockPos(this.x * 3 * 16 + x, y, this.z * 3 * 16 + z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridPos gridPos = (GridPos)o;
        return this.x == gridPos.x && this.z == gridPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return "<" + this.x + ", " + this.z + ">";
    }

    public static int chunkToGridCoords(int c) {
        return Math.floorDiv(c, 3);
    }

    public static int blockToGridCoords(int c) {
        return Math.floorDiv(c >> 4, 3);
    }

    public static GridPos fromChunkCoords(int cx, int cz) {
        return new GridPos(GridPos.chunkToGridCoords(cx), GridPos.chunkToGridCoords(cz));
    }
}

