/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import hellfall.visualores.database.gregtech.ore.GridCache;
import hellfall.visualores.database.gregtech.ore.GridPos;
import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class DimensionCache {
    private final Map<GridPos, GridCache> cache = new HashMap<GridPos, GridCache>();
    public boolean dirty;

    public boolean addVein(int x, int z, int gridX, int gridZ, String name) {
        boolean added;
        GridPos key = new GridPos(gridX, gridZ);
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new GridCache());
        }
        this.dirty = (added = this.cache.get(key).addVein(x, z, name)) || this.dirty;
        return added;
    }

    public NBTTagCompound toNBT(boolean saveDepleted) {
        return this.toNBT(new NBTTagCompound(), saveDepleted);
    }

    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        return this.toNBT(nbt, false);
    }

    public NBTTagCompound toNBT(NBTTagCompound nbt, boolean saveDepleted) {
        for (GridPos key : this.cache.keySet()) {
            nbt.func_74782_a(key.x + "," + key.z, (NBTBase)this.cache.get(key).toNBT(saveDepleted));
        }
        return nbt;
    }

    public void fromNBT(NBTTagCompound tag) {
        for (String gridpos : tag.func_150296_c()) {
            String[] splitpos = gridpos.split(",");
            GridPos key = new GridPos(Integer.parseInt(splitpos[0]), Integer.parseInt(splitpos[1]));
            if (!this.cache.containsKey(key)) {
                this.cache.put(key, new GridCache());
            }
            this.cache.get(key).fromNBT(tag.func_150295_c(gridpos, 10));
        }
    }

    public List<OreVeinPosition> getNearbyVeins(BlockPos pos, int blockRadius) {
        return this.getVeinsInBounds(pos.func_177982_a(-blockRadius, 0, -blockRadius), pos.func_177982_a(blockRadius, 0, blockRadius));
    }

    public List<OreVeinPosition> getVeinsInBounds(BlockPos topLeftBlock, BlockPos bottomRightBlock) {
        GridPos topLeft = new GridPos(topLeftBlock);
        GridPos bottomRight = new GridPos(bottomRightBlock);
        ArrayList<OreVeinPosition> found = new ArrayList<OreVeinPosition>();
        for (int i = topLeft.x; i <= bottomRight.x; ++i) {
            for (int j = topLeft.z; j <= bottomRight.z; ++j) {
                GridPos curPos = new GridPos(i, j);
                if (!this.cache.containsKey(curPos)) continue;
                found.addAll(this.cache.get(curPos).getVeinsMatching(veinpos -> veinpos.x >= topLeftBlock.func_177958_n() && veinpos.x <= bottomRightBlock.func_177958_n() && veinpos.z >= topLeftBlock.func_177952_p() && veinpos.z <= bottomRightBlock.func_177952_p()));
            }
        }
        return found;
    }

    public List<OreVeinPosition> getVeinsInChunk(ChunkPos pos) {
        GridPos gpos = new GridPos(pos);
        if (this.cache.containsKey(gpos)) {
            return this.cache.get(gpos).getVeinsMatching(veinpos -> pos.equals((Object)new ChunkPos(veinpos.x >> 4, veinpos.z >> 4)));
        }
        return new ArrayList<OreVeinPosition>();
    }

    public void removeAllInChunk(ChunkPos pos) {
        GridPos gpos = new GridPos(pos);
        if (this.cache.containsKey(gpos)) {
            this.cache.get(gpos).removeVeinsMatching(veinpos -> pos.equals((Object)new ChunkPos(veinpos.x >> 4, veinpos.z >> 4)));
        }
    }
}

