/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech;

import hellfall.visualores.database.IClientCache;
import hellfall.visualores.database.gregtech.fluid.FluidCache;
import hellfall.visualores.database.gregtech.fluid.UndergroundFluidPosition;
import hellfall.visualores.database.gregtech.ore.DimensionCache;
import hellfall.visualores.database.gregtech.ore.WorldCache;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GTClientCache
extends WorldCache
implements IClientCache {
    public static final GTClientCache instance = new GTClientCache();
    private final FluidCache fluids = new FluidCache();

    public void notifyNewVeins(int amount) {
        if (amount <= 0) {
            return;
        }
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("visualores.gregtech.newveins", new Object[]{amount}));
    }

    public void addFluid(int dim, int fieldX, int fieldZ, String name, int yield, double percent) {
        this.fluids.addFluid(dim, fieldX, fieldZ, name, yield, percent);
    }

    public List<UndergroundFluidPosition> getFluidsInArea(int dim, int[] bounds) {
        return this.fluids.getFluidsInBounds(dim, new BlockPos(bounds[0], 0, bounds[1]), new BlockPos(bounds[0] + bounds[2], 0, bounds[1] + bounds[3]));
    }

    @Override
    public Collection<Integer> getExistingDimensions(String prefix) {
        return this.cache.keySet();
    }

    @Override
    public NBTTagCompound saveDimFile(String prefix, int dim) {
        if (!this.cache.containsKey(dim)) {
            return null;
        }
        return ((DimensionCache)this.cache.get(dim)).toNBT(true);
    }

    @Override
    public NBTTagCompound saveSingleFile(String name) {
        return this.fluids.toNBT();
    }

    @Override
    public void readDimFile(String prefix, int dim, NBTTagCompound data) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        ((DimensionCache)this.cache.get(dim)).fromNBT(data);
    }

    @Override
    public void readSingleFile(String name, NBTTagCompound data) {
        this.fluids.fromNBT(data);
    }

    @Override
    public void setupCacheFiles() {
        this.addDimFiles();
        this.addSingleFile("fluids");
    }

    @Override
    public void clear() {
        super.clear();
        this.fluids.clear();
    }
}

