/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores;

import net.minecraftforge.common.config.Config;

@Config(modid="visualores")
public class VOConfig {
    @Config.Comment(value={"Client-side config options"})
    @Config.Name(value="Client Options")
    public static ClientOptions client = new ClientOptions();
    @Config.Comment(value={"Server-side config options"})
    @Config.Name(value="Server Options")
    public static ServerOptions server = new ServerOptions();

    public static class ClientOptions {
        @Config.Name(value="Gregtech")
        public GTClientOptions gregtech = new GTClientOptions();
        @Config.Name(value="Journeymap")
        public JourneymapOptions jmap = new JourneymapOptions();
        @Config.Name(value="Xaero's Maps")
        public XaerosMapOptions xmap = new XaerosMapOptions();
        @Config.Comment(value={"Whether to display tooltips for all overlays in the same location."})
        public boolean stackTooltips = true;
        @Config.Comment(value={"Whether to enable rendering on minimaps"})
        public boolean enableMinimapRendering = true;
        @Config.Comment(value={"Whether to allow multiple overlays to render at the same time"})
        public boolean allowMultipleLayers = false;
        @Config.Comment(value={"Whether to reverse the normal order of buttons"})
        public boolean reverseButtonOrder = false;
        @Config.Comment(value={"What the normal order of buttons (and layers) should be"})
        @Config.RequiresMcRestart
        public String[] buttonOrder = new String[]{"oreveins", "excavator", "undergroundfluid", "neromantic", "aura_flux", "starlight"};
        @Config.Comment(value={"Layers to not register"})
        @Config.RequiresMcRestart
        public String[] ignoreLayers = new String[0];
        @Config.Comment(value={"Fluid colors to override in the underground fluid overlay", "Format: fluid name=RGB color"})
        @Config.RequiresMcRestart
        public String[] fluidColorOverrides = new String[]{"water=#6B7AF7", "lava=#D14F0C"};

        public static class GTClientOptions {
            @Config.Comment(value={"The map scale at which displayed ores will stop scaling."})
            @Config.RangeDouble(min=0.1, max=16.0)
            public double oreScaleStop = 1.0;
            @Config.Comment(value={"The size, in pixels, of ore icons on the map"})
            @Config.RangeInt(min=4)
            public int oreIconSize = 32;
            @Config.Comment(value={"The string prepending ore names in the ore vein tooltip"})
            public String oreNamePrefix = "- ";
            @Config.Comment(value={"The color to draw a box around the ore icon with.", "Accepts either an ARGB hex color prefixed with # or the string 'material' to use the ore's material color"})
            public String borderColor = "#00000000";

            public int getBorderColor(int materialColor) {
                if (this.borderColor.equals("material")) {
                    return materialColor;
                }
                try {
                    long tmp = Long.decode(this.borderColor);
                    if (tmp > Integer.MAX_VALUE) {
                        tmp -= 0x100000000L;
                    }
                    return (int)tmp;
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        }

        public static class JourneymapOptions {
            @Config.Comment(value={"Whether to put buttons on a separate toolbar on the right instead of the map type toolbar."})
            public boolean rightToolbar = true;
        }

        public static class XaerosMapOptions {
            @Config.Comment(value={"Which part of the screen to anchor buttons to"})
            public Anchor buttonAnchor = Anchor.BOTTOM_LEFT;
            @Config.Comment(value={"Which direction the buttons will go"})
            public Direction direction = Direction.HORIZONTAL;
            @Config.Comment(value={"How horizontally far away from the anchor to place the buttons"})
            public int xOffset = 20;
            @Config.Comment(value={"How vertically far away from the anchor to place the buttons"})
            public int yOffset = 0;

            public static enum Anchor {
                TOP_LEFT,
                TOP_CENTER,
                TOP_RIGHT,
                RIGHT_CENTER,
                BOTTOM_RIGHT,
                BOTTOM_CENTER,
                BOTTOM_LEFT,
                LEFT_CENTER;


                public boolean isCentered() {
                    return this == TOP_CENTER || this == RIGHT_CENTER || this == BOTTOM_CENTER || this == LEFT_CENTER;
                }

                public Direction usualDirection() {
                    Direction direction;
                    switch (this) {
                        case TOP_CENTER: 
                        case BOTTOM_CENTER: {
                            direction = Direction.HORIZONTAL;
                            break;
                        }
                        case RIGHT_CENTER: 
                        case LEFT_CENTER: {
                            direction = Direction.VERTICAL;
                            break;
                        }
                        default: {
                            direction = null;
                        }
                    }
                    return direction;
                }
            }

            public static enum Direction {
                VERTICAL,
                HORIZONTAL;

            }
        }
    }

    public static class ServerOptions {
        @Config.Name(value="Gregtech")
        public GTServerOptions gregtech = new GTServerOptions();

        public static class GTServerOptions {
            @Config.Comment(value={"The radius, in blocks, that picking up a surface rock will search for veins in.", "-1 to disable.", "Default: 24"})
            @Config.RangeInt(min=1)
            public int surfaceRockProspectRange = 24;
            @Config.Comment(value={"The radius, in blocks, that clicking an ore block will search for veins in.", "-1 to disable", "Default: 24"})
            @Config.RangeInt(min=1)
            public int oreBlockProspectRange = 24;
            @Config.Comment(value={"Whether to cull cache entries in chunks that nothing generated in.", "Prevents \"phantom veins\" from being recorded in, for example, the End void.", "Can cause veins to not be recorded if they only generated blocks in chunks other than their centers. (i.e. at the edge of end islands)", "Default: true"})
            public boolean cullEmptyChunks = true;
            @Config.Comment(value={"Whether to cull cache entries in chunks that nothing generated in during retrogen (V1 algorithm only).", "Will make retrogen take longer!", "Will also make veins containing only non-gt ores be removed", "Default: true"})
            public boolean cullEmptyChunksRetrogen = true;
            @Config.Comment(value={"Whether to perform retrogen for the ore vein cache.", "Default: true"})
            public boolean doRetrogen = true;
            @Config.Comment(value={"Whether to use the V1 retrogen algorithm for retrogen on worlds with 5u-style oregen instead of V2", "(eg. exactly one vein in the center of each generation chunk)", "The V2 algorithm is much more accurate and (theoretically) faster, but can still have accuracy issues with veins containing non-gt ore blocks", "(and does not work with non-5u oregen at the moment, V1 will currently always be used if the oregen pattern is different)", "Default: False"})
            public boolean forceRetrogenV1 = false;
        }
    }
}

