/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static boolean containsIgnoreCase(Collection<String> collection, String targetString) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (String string : collection) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)targetString)) continue;
            return true;
        }
        return false;
    }

    public static String convertColor(String string) {
        return string.replaceAll("(?i)&([0-9A-FK-OR])", "\u00a7$1");
    }

    public static String filter(String string) {
        return string.replaceAll("[^\\x20-\\x7E\\x0A\\x0D]", "");
    }

    public static String toString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "null";
    }

    public static String toString(JsonElement jsonElement) throws UnsupportedOperationException {
        if (jsonElement instanceof JsonPrimitive) {
            return jsonElement.getAsString();
        }
        if (jsonElement instanceof JsonArray) {
            return StringUtils.toString((JsonArray)jsonElement);
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", jsonElement.getClass().getSimpleName()));
    }

    public static String toString(JsonArray jsonArray) throws UnsupportedOperationException {
        StringBuilder stringBuilder = new StringBuilder();
        for (JsonElement jsonElement : jsonArray) {
            if (!(jsonElement instanceof JsonPrimitive)) {
                throw new UnsupportedOperationException(String.format("%s is not supported inside a JsonArray", jsonElement.getClass().getSimpleName()));
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(jsonElement.getAsString());
        }
        return stringBuilder.toString();
    }
}

