/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.platform;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import io.github.lxgaming.sledgehammer.manager.IntegrationManager;
import io.github.lxgaming.sledgehammer.manager.LocaleManager;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameAboutToStartServerEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameLoadCompleteEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStateEvent;
import org.spongepowered.api.event.game.state.GameStoppedEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SledgehammerPlatform.class}, priority=1337, remap=false)
public abstract class SledgehammerPlatformMixin_Plugin {
    @Shadow
    private static SledgehammerPlatform instance;
    private SledgehammerPlatform.State platform$state;

    @Listener
    public void onGameState(GameStateEvent event) {
        MappingManager.getStateMapping(event.getClass()).ifPresent(this::platform$setState);
    }

    @Listener
    public void onLoadComplete(GameLoadCompleteEvent event) {
        Sledgehammer.getInstance().getLogger().info("{} v{} has loaded", (Object)"Sledgehammer", (Object)"1.12.2-2.0.26");
    }

    @Listener
    public void onStopped(GameStoppedEvent event) {
        Sledgehammer.getInstance().getLogger().info("{} v{} has stopped", (Object)"Sledgehammer", (Object)"1.12.2-2.0.26");
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo callbackInfo) {
        instance = Toolbox.cast(this, SledgehammerPlatform.class);
        this.platform$state = SledgehammerPlatform.State.CONSTRUCTION;
        Sledgehammer.init();
        CommandManager.prepare();
        IntegrationManager.prepare();
        LocaleManager.prepare();
        MappingManager.STATE_MAPPINGS.put(GamePreInitializationEvent.class, SledgehammerPlatform.State.PRE_INITIALIZATION);
        MappingManager.STATE_MAPPINGS.put(GameInitializationEvent.class, SledgehammerPlatform.State.INITIALIZATION);
        MappingManager.STATE_MAPPINGS.put(GamePostInitializationEvent.class, SledgehammerPlatform.State.POST_INITIALIZATION);
        MappingManager.STATE_MAPPINGS.put(GameLoadCompleteEvent.class, SledgehammerPlatform.State.LOAD_COMPLETE);
        MappingManager.STATE_MAPPINGS.put(GameAboutToStartServerEvent.class, SledgehammerPlatform.State.SERVER_ABOUT_TO_START);
        MappingManager.STATE_MAPPINGS.put(GameStartingServerEvent.class, SledgehammerPlatform.State.SERVER_STARTING);
        MappingManager.STATE_MAPPINGS.put(GameStartedServerEvent.class, SledgehammerPlatform.State.SERVER_STARTED);
        MappingManager.STATE_MAPPINGS.put(GameStoppingServerEvent.class, SledgehammerPlatform.State.SERVER_STOPPING);
        MappingManager.STATE_MAPPINGS.put(GameStoppedServerEvent.class, SledgehammerPlatform.State.SERVER_STOPPED);
        IntegrationManager.execute();
    }

    @Overwrite
    public boolean isLoaded(@Nonnull String id) {
        return Sponge.getPluginManager().isLoaded(id);
    }

    @Overwrite
    @Nullable
    public Object getContainer() {
        return Sponge.getPluginManager().getPlugin("sledgehammer").orElse(null);
    }

    @Overwrite
    @Nullable
    public MinecraftServer getServer() {
        if (Sponge.isServerAvailable()) {
            return (MinecraftServer)Sponge.getServer();
        }
        return null;
    }

    @Overwrite
    @Nonnull
    public SledgehammerPlatform.State getState() {
        return this.platform$state;
    }

    private void platform$setState(SledgehammerPlatform.State state) {
        if (state == null) {
            return;
        }
        Sledgehammer.getInstance().getLogger().debug("State: {} -> {}", (Object)this.platform$state.getName(), (Object)state.getName());
        this.platform$state = state;
        IntegrationManager.execute();
    }

    @Overwrite
    @Nonnull
    public SledgehammerPlatform.Type getType() {
        return SledgehammerPlatform.Type.SPONGE;
    }
}

