/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.core.server.management;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.util.PrettyPrinterProxy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;

@Mixin(value={PlayerChunkMap.class}, priority=1337)
public abstract class PlayerChunkMapMixin {
    private final AtomicBoolean sledgehammer$lock = new AtomicBoolean(false);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTickPre(CallbackInfo callbackInfo) {
        if (!this.sledgehammer$lock.compareAndSet(false, true)) {
            Sledgehammer.getInstance().getLogger().error("Unexpected lock state: true");
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTickPost(CallbackInfo callbackInfo) {
        if (!this.sledgehammer$lock.compareAndSet(true, false)) {
            Sledgehammer.getInstance().getLogger().error("Unexpected lock state: false");
        }
    }

    @Inject(method={"entryChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEntryChanged(PlayerChunkMapEntry entry, CallbackInfo callbackInfo) {
        if (this.sledgehammer$lock.get()) {
            PrettyPrinterProxy.error(new PrettyPrinter().add("Tried to mark PlayerChunkMapEntry as dirty while locked").centre().hr().add("Chunk: %d, %d", entry.func_187264_a().field_77276_a, entry.func_187264_a().field_77275_b).add("Players: %s", entry.getWatchingPlayers().stream().map(EntityPlayer::func_70005_c_).collect(Collectors.joining(", "))).add("StackTrace:").add(new Exception(String.format("%s v%s", "Sledgehammer", "1.12.2-2.0.26"))));
            callbackInfo.cancel();
        }
    }

    @Inject(method={"removeEntry"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRemoveEntry(PlayerChunkMapEntry entry, CallbackInfo callbackInfo) {
        if (this.sledgehammer$lock.get()) {
            PrettyPrinterProxy.error(new PrettyPrinter().add("Tried to remove PlayerChunkMapEntry while locked").centre().hr().add("Chunk: %d, %d", entry.func_187264_a().field_77276_a, entry.func_187264_a().field_77275_b).add("Players: %s", entry.getWatchingPlayers().stream().map(EntityPlayer::func_70005_c_).collect(Collectors.joining(", "))).add("StackTrace:").add(new Exception(String.format("%s v%s", "Sledgehammer", "1.12.2-2.0.26"))));
            callbackInfo.cancel();
        }
    }
}

