/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.core.entity;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.util.PrettyPrinterProxy;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;

@Mixin(value={EntityTracker.class})
public abstract class EntityTrackerMixin {
    private final AtomicBoolean sledgehammer$lock = new AtomicBoolean(false);

    @Inject(method={"sendLeashedEntitiesInChunk"}, at={@At(value="HEAD")})
    private void onSendLeashedEntitiesInChunkPre(CallbackInfo callbackInfo) {
        if (!this.sledgehammer$lock.compareAndSet(false, true)) {
            Sledgehammer.getInstance().getLogger().error("Unexpected lock state: true");
        }
    }

    @Inject(method={"sendLeashedEntitiesInChunk"}, at={@At(value="RETURN")})
    private void onSendLeashedEntitiesInChunkPost(CallbackInfo callbackInfo) {
        if (!this.sledgehammer$lock.compareAndSet(true, false)) {
            Sledgehammer.getInstance().getLogger().error("Unexpected lock state: false");
        }
    }

    @Inject(method={"track(Lnet/minecraft/entity/Entity;IIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTrack(Entity entity, int trackingRange, int updateFrequency, boolean sendVelocityUpdates, CallbackInfo callbackInfo) {
        if (this.sledgehammer$lock.get()) {
            PrettyPrinterProxy.error(new PrettyPrinter().add("Tried to track entity while locked").centre().hr().add("StackTrace:").add(new Exception(String.format("%s v%s", "Sledgehammer", "1.12.2-2.0.26"))));
            callbackInfo.cancel();
        }
    }

    @Inject(method={"untrack(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUntrack(Entity entity, CallbackInfo callbackInfo) {
        if (this.sledgehammer$lock.get()) {
            PrettyPrinterProxy.error(new PrettyPrinter().add("Tried to untrack entity while locked").centre().hr().add("StackTrace:").add(new Exception(String.format("%s v%s", "Sledgehammer", "1.12.2-2.0.26"))));
            callbackInfo.cancel();
        }
    }
}

