/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.TypeSerializer;
import java.util.UUID;

class UUIDSerializer
implements TypeSerializer<UUID> {
    UUIDSerializer() {
    }

    @Override
    public UUID deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        try {
            return UUID.fromString(value.getString());
        }
        catch (IllegalArgumentException ex) {
            throw new ObjectMappingException("Value not a UUID", ex);
        }
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable UUID obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj.toString());
    }
}

