/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.AbstractListChildSerializer;
import io.github.lxgaming.sledgehammer.lib.configurate.util.CheckedConsumer;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    ListSerializer() {
    }

    @Override
    TypeToken<?> getElementType(TypeToken<?> containerType) throws ObjectMappingException {
        if (!(containerType.getType() instanceof ParameterizedType)) {
            throw new ObjectMappingException("Raw types are not supported for collections");
        }
        return containerType.resolveType(List.class.getTypeParameters()[0]);
    }

    @Override
    List<?> createNew(int length, TypeToken<?> elementType) {
        return new ArrayList(length);
    }

    @Override
    void forEachElement(List<?> collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    void deserializeSingle(int index, List<?> collection, Object deserialized) {
        collection.add(deserialized);
    }
}

