/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.compat.architect;

import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.shape.EnumShape;
import com.elytradev.architecture.common.shape.ShapeKind;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Predicate;
import li.cil.architect.api.converter.Converter;
import li.cil.architect.api.converter.MaterialSource;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import scala.actors.threadpool.Arrays;

public class ArchitectConverter
implements Converter {
    private static final UUID CONVERTER_UUID = UUID.fromString("182148b6-fba8-4acb-95a5-66409d34eb59");
    private static final int[] ROTATE_DISCONNECTED = new int[256];
    private final Item shapeItem;
    private final Item claddingItem;
    private final Block shapeBlock;

    ArchitectConverter() {
        this.shapeBlock = ArchitectureMod.CONTENT.blockShape;
        this.shapeItem = Item.func_150898_a((Block)this.shapeBlock);
        this.claddingItem = ArchitectureMod.CONTENT.itemCladding;
    }

    private static boolean consume(IItemHandler itemHandler, Item item, int amount, int meta, Predicate<NBTTagCompound> test) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            NBTTagCompound stackData;
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190916_E() == 0 || stack.func_77973_b() != item || stack.func_77960_j() != meta || test != null && ((stackData = stack.func_77978_p()) == null || !test.test(stackData)) || (amount -= itemHandler.extractItem(i, amount, false).func_190916_E()) != 0) continue;
            return true;
        }
        return false;
    }

    public UUID getUUID() {
        return CONVERTER_UUID;
    }

    public Iterable<ItemStack> getItemCosts(NBTBase nbtBase) {
        NBTTagCompound data = (NBTTagCompound)nbtBase;
        if (data.func_74764_b("Name2")) {
            return Arrays.asList((Object[])new ItemStack[]{this.getItemStackForBlock(data), this.getCladdingForBlock(data)});
        }
        return Collections.singletonList(this.getItemStackForBlock(data));
    }

    public Iterable<FluidStack> getFluidCosts(NBTBase nbtBase) {
        return Collections.emptyList();
    }

    public int getSortIndex(NBTBase nbtBase) {
        return 0;
    }

    public boolean canSerialize(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_177230_c() == this.shapeBlock;
    }

    public NBTBase serialize(World world, BlockPos blockPos) {
        IBlockState state = world.func_180495_p(blockPos);
        if (state.func_177230_c() != this.shapeBlock) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound original = tileEntity.serializeNBT();
        NBTTagCompound data = new NBTTagCompound();
        byte turn = original.func_74771_c("turn");
        byte side = original.func_74771_c("side");
        int disconnected = original.func_74762_e("Disconnected");
        if (turn != 0) {
            data.func_74774_a("turn", turn);
        }
        if (side != 0) {
            data.func_74774_a("side", side);
        }
        if (disconnected != 0) {
            data.func_74768_a("Disconnected", disconnected);
        }
        data.func_74768_a("Shape", original.func_74762_e("Shape"));
        data.func_74778_a("BaseName", original.func_74779_i("BaseName"));
        data.func_74768_a("BaseData", original.func_74762_e("BaseData"));
        if (original.func_74764_b("Name2")) {
            data.func_74778_a("Name2", original.func_74779_i("Name2"));
            data.func_74768_a("Data2", original.func_74762_e("Data2"));
        }
        return data;
    }

    public boolean preDeserialize(MaterialSource materialSource, World world, BlockPos blockPos, Rotation rotation, NBTBase nbtBase) {
        NBTTagCompound data;
        if (materialSource.isCreative()) {
            return true;
        }
        IItemHandler itemHandler = materialSource.getItemHandler();
        return this.consume(itemHandler, data = (NBTTagCompound)nbtBase) && this.consumeCladding(materialSource, data);
    }

    private boolean consume(IItemHandler itemHandler, NBTTagCompound data) {
        int shape = data.func_74762_e("Shape");
        String name = data.func_74779_i("BaseName");
        int meta = data.func_74762_e("BaseData");
        return ArchitectConverter.consume(itemHandler, this.shapeItem, 1, 0, stackData -> stackData.func_74762_e("Shape") == shape && stackData.func_74779_i("BaseName").equals(name) && stackData.func_74762_e("BaseData") == meta);
    }

    private boolean consumeCladding(MaterialSource source, NBTTagCompound data) {
        if (!data.func_74764_b("Name2")) {
            return true;
        }
        EnumShape shape = EnumShape.forId(data.func_74762_e("Shape"));
        String name = data.func_74779_i("Name2");
        int meta = data.func_74762_e("Data2");
        if (shape.kind instanceof ShapeKind.Window) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            return ArchitectConverter.consume(source.getItemHandler(), item, 1, meta, null);
        }
        IItemHandler itemHandler = source.getItemHandler();
        return ArchitectConverter.consume(itemHandler, this.claddingItem, 1, meta, stackData -> stackData.func_74779_i("block").equals(name));
    }

    public void deserialize(World world, BlockPos blockPos, Rotation rotation, NBTBase nbtBase) {
        NBTTagCompound data = (NBTTagCompound)nbtBase.func_74737_b();
        this.rotate(data, rotation);
        world.func_175656_a(blockPos, this.shapeBlock.func_176203_a(data.func_74762_e("BaseData")));
        TileShape shape = new TileShape();
        shape.func_145839_a(data);
        world.func_175690_a(blockPos, (TileEntity)shape);
    }

    public void cancelDeserialization(World world, BlockPos blockPos, Rotation rotation, NBTBase nbtBase) {
        world.func_175698_g(blockPos);
    }

    private void rotate(NBTTagCompound data, Rotation rotation) {
        byte turn = data.func_74771_c("turn");
        byte side = data.func_74771_c("side");
        if (side == 0) {
            turn = (byte)(turn - rotation.ordinal() + 4 & 3);
        } else if (side == 1) {
            turn = (byte)(turn + rotation.ordinal() & 3);
        } else {
            EnumFacing sideValue = EnumFacing.func_176731_b((int)side);
            side = (byte)EnumFacing.func_176731_b((int)(sideValue.func_176736_b() + rotation.ordinal() & 3)).ordinal();
        }
        int disconnected = data.func_74762_e("Disconnected");
        if (disconnected != 0 && rotation != Rotation.NONE) {
            disconnected = ROTATE_DISCONNECTED[disconnected + 64 * rotation.ordinal()];
            data.func_74768_a("Disconnected", disconnected);
        }
        data.func_74774_a("turn", turn);
        data.func_74774_a("side", side);
    }

    private ItemStack getItemStackForBlock(NBTTagCompound data) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Shape", data.func_74762_e("Shape"));
        nbt.func_74778_a("BaseName", data.func_74779_i("BaseName"));
        nbt.func_74768_a("BaseData", data.func_74762_e("BaseData"));
        ItemStack stack = new ItemStack(this.shapeItem, 1, 0);
        stack.func_77982_d(nbt);
        return stack;
    }

    private ItemStack getCladdingForBlock(NBTTagCompound data) {
        EnumShape shape = EnumShape.forId(data.func_74762_e("Shape"));
        if (shape.kind instanceof ShapeKind.Window) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(data.func_74779_i("Name2")));
            return new ItemStack(item, 1, data.func_74762_e("Data2"));
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("block", data.func_74779_i("Name2"));
        ItemStack stack = new ItemStack(this.claddingItem, 1, data.func_74762_e("Data2"));
        stack.func_77982_d(nbt);
        return stack;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            for (int rotation = 0; rotation < 4; ++rotation) {
                int result = i & 3;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    int bit = 1 << facing.ordinal();
                    if ((i & bit) <= 0) continue;
                    EnumFacing rotated = EnumFacing.func_176731_b((int)(facing.func_176736_b() + rotation & 3));
                    result |= 1 << rotated.ordinal();
                }
                ArchitectConverter.ROTATE_DISCONNECTED[i + 64 * rotation] = result;
            }
        }
    }
}

