/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.item;

import com.elytradev.architecture.common.block.BlockHelper;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.item.ItemArchitecture;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemCladding
extends ItemArchitecture {
    public ItemStack newStack(IBlockState state, int stackSize) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return this.newStack(block, meta, stackSize);
    }

    public ItemStack newStack(Block block, int meta, int stackSize) {
        ItemStack result = new ItemStack((Item)this, stackSize, meta);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("block", BlockHelper.getNameForBlock(block));
        result.func_77982_d(nbt);
        return result;
    }

    public IBlockState blockStateFromStack(ItemStack stack) {
        Block block;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && (block = Block.func_149684_b((String)nbt.func_74779_i("block"))) != null) {
            return block.func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        lines.set(0, super.func_77653_i(stack));
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            Block block = Block.func_149684_b((String)tag.func_74779_i("block"));
            int meta = stack.func_77952_i();
            if (block != null) {
                lines.add(Utils.displayNameOfBlock(block, meta));
            }
        }
    }

    protected boolean func_194125_a(CreativeTabs targetTab) {
        return false;
    }

    @Override
    public int getNumSubtypes() {
        return 16;
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return super.func_77653_i(stack);
        }
        Block baseBlock = Block.func_149684_b((String)tag.func_74779_i("block"));
        return I18n.func_74838_a((String)"item.architecturecraft.cladding.name") + ": " + Utils.displayNameOnlyOfBlock(baseBlock, stack.func_77960_j());
    }
}

