/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.shape;

import com.elytradev.architecture.client.proxy.ClientProxy;
import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.tile.TileShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class RenderShape {
    protected IBlockAccess blockWorld;
    protected BlockPos blockPos;
    protected TileShape te;
    protected ITexture[] textures;
    protected Trans3 t;
    protected RenderTargetBase target;
    private int baseColourMult;
    private int secondaryColourMult;

    public RenderShape(TileShape te, ITexture[] textures, Trans3 t, RenderTargetBase target) {
        this.te = te;
        this.blockWorld = te.func_145831_w();
        this.blockPos = te.func_174877_v();
        this.textures = textures;
        this.t = t;
        this.target = target;
    }

    protected abstract void render();

    protected IArchitectureModel getModel(String name) {
        return ClientProxy.RENDERING_MANAGER.getModel(name);
    }

    public int getBaseColourMult() {
        return this.baseColourMult;
    }

    public void setBaseColourMult(int baseColourMult) {
        this.baseColourMult = baseColourMult;
    }

    public int getSecondaryColourMult() {
        return this.secondaryColourMult;
    }

    public void setSecondaryColourMult(int secondaryColourMult) {
        this.secondaryColourMult = secondaryColourMult;
    }
}

