/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render;

import com.elytradev.architecture.client.proxy.ClientProxy;
import com.elytradev.architecture.client.render.shape.ShapeRenderDispatch;
import com.elytradev.architecture.client.render.target.RenderTargetWorld;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.ItemShape;
import com.elytradev.architecture.common.tile.TileShape;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PreviewRenderer {
    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent e) {
        if (!e.isCanceled()) {
            ItemStack stack;
            EntityPlayer player = e.getPlayer();
            World world = player.func_130014_f_();
            ItemStack itemStack = stack = player.func_184614_ca().func_77973_b() instanceof ItemShape ? player.func_184614_ca() : player.func_184592_cb();
            if (stack.func_77973_b() instanceof ItemShape) {
                RayTraceResult hit = e.getTarget();
                if (hit.field_72313_a != RayTraceResult.Type.BLOCK || !world.func_175623_d(hit.func_178782_a().func_177972_a(hit.field_178784_b))) {
                    return;
                }
                float hX = (float)hit.field_72307_f.field_72450_a;
                float hY = (float)hit.field_72307_f.field_72448_b;
                float hZ = (float)hit.field_72307_f.field_72449_c;
                BlockPos pos = hit.func_178782_a().func_177972_a(hit.field_178784_b);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buff = tess.func_178180_c();
                RenderTargetWorld target = new RenderTargetWorld((IBlockAccess)world, pos, buff, null);
                ShapeRenderDispatch shapeDispatcher = ClientProxy.SHAPE_RENDER_DISPATCHER;
                BlockShape blockShape = ArchitectureMod.CONTENT.blockShape;
                BlockArchitecture.IOrientationHandler oh = blockShape.getOrientationHandler();
                IBlockState state = oh.onBlockPlaced((Block)blockShape, world, pos, hit.field_178784_b, hX, hY, hZ, blockShape.func_176223_P(), (EntityLivingBase)player);
                TileShape shape = new TileShape();
                shape.func_174878_a(pos);
                shape.func_145834_a(world);
                shape.readFromItemStack(stack);
                PreviewRenderer.simulatePlacement(player, (IBlockAccess)world, shape, hit);
                Trans3 t = Trans3.blockCenter(pos).t(shape.localToGlobalTransformation(Vector3.zero, state));
                double tX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)e.getPartialTicks();
                double tY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)e.getPartialTicks();
                double tZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)e.getPartialTicks();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-tX), (double)(-tY), (double)(-tZ));
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179089_o();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                shapeDispatcher.renderShapeTE(shape, target, t, true, false, Utils.getColourFromState(shape.getBaseBlockState()), -1);
                tess.func_78381_a();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    private static void simulatePlacement(EntityPlayer player, IBlockAccess world, TileShape shape, RayTraceResult hit) {
        Vec3i direction = Vector3.getDirectionVec(hit.field_178784_b);
        Vector3 hitVec = new Vector3(hit.field_72307_f.func_178786_a((double)hit.func_178782_a().func_177958_n(), (double)hit.func_178782_a().func_177956_o(), (double)hit.func_178782_a().func_177952_p()));
        hitVec = new Vector3(hitVec.x - (double)direction.func_177958_n() - 0.5, hitVec.y - (double)direction.func_177956_o() - 0.5, hitVec.z - (double)direction.func_177952_p() - 0.5);
        BlockPos neighbourPos = hit.func_178782_a();
        IBlockState neighbourState = world.func_180495_p(neighbourPos);
        TileEntity neighbourTile = world.func_175625_s(neighbourPos);
        shape.getShape().orientOnPlacement(player, shape, neighbourPos, neighbourState, neighbourTile, hit.field_178784_b, hitVec);
    }
}

