/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.util.client;

import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.renderers.controls.RenderDoor;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.client.worldshell.RenderWorldShell;
import net.tardis.mod.client.worldshell.WorldBoti;
import net.tardis.mod.proxy.ClientProxy;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    private static WorldBoti wBoti;
    private static FloatBuffer FOG_BUFFER;
    private static float lastBrightnessX;
    private static float lastBrightnessY;

    public static void renderPortal(RenderWorldShell renderShell, IContainsWorldShell te, float partialTicks, float rotation, @Nullable Vec3d offset, @Nullable Vec3d size, boolean renderFog) {
        if (ClientProxy.getRenderBOTI() && MinecraftForgeClient.getRenderPass() == 1) {
            if (offset == null) {
                offset = new Vec3d(-1.0, 0.0, -7.0);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2960);
            GL11.glStencilFunc((int)519, (int)1, (int)255);
            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
            GL11.glStencilMask((int)255);
            GL11.glClear((int)1024);
            GlStateManager.func_179132_a((boolean)false);
            RenderHelper.drawOutline(size);
            GlStateManager.func_179132_a((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)1, (int)255);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            if (te.getRenderWorld() != null) {
                wBoti = (WorldBoti)te.getRenderWorld();
            } else if (wBoti == null || RenderHelper.wBoti.dimension != te.getDimension()) {
                wBoti = new WorldBoti(te.getDimension(), Minecraft.func_71410_x().field_71441_e, te.getWorldShell());
            }
            WorldClient oldW = Minecraft.func_71410_x().field_71441_e;
            RenderHelper.setRenderGlobalWorld(wBoti);
            wBoti.func_72877_b(te.getWorldShell().getTime());
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            if (!RenderHelper.wBoti.field_73011_w.func_76561_g()) {
                GlStateManager.func_179094_E();
                Vec3d color = RenderHelper.wBoti.field_73011_w.func_76562_b(0.0f, 0.0f);
                GlStateManager.func_179127_m();
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
                if (color != null) {
                    FOG_BUFFER.clear();
                    FOG_BUFFER.put((float)color.field_72450_a).put((float)color.field_72448_b).put((float)color.field_72449_c).put(1.0f);
                    FOG_BUFFER.flip();
                    GlStateManager.func_187402_b((int)2918, (FloatBuffer)FOG_BUFFER);
                }
                GlStateManager.func_179095_a((float)0.01f);
                GlStateManager.func_179102_b((float)10.0f);
                GlStateManager.func_179153_c((float)20.0f);
                GlStateManager.func_179106_n();
                GlStateManager.func_179121_F();
            }
            Minecraft.func_71410_x().field_71438_f.func_174976_a(partialTicks, 2);
            RenderWorldShell.renderWorldShell(te, wBoti, offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            GlStateManager.func_179121_F();
            RenderHelper.setRenderGlobalWorld(oldW);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GL11.glDisable((int)2960);
            GL11.glClear((int)1024);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179132_a((boolean)false);
            RenderHelper.drawOutline(size);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
        if (!ClientProxy.getRenderBOTI()) {
            RenderHelper.drawOutline(size);
        }
    }

    public static void renderPortal(RenderWorldShell renderShell, IContainsWorldShell te, float partialTicks, float rotation, @Nullable Vec3d offset, @Nullable Vec3d size) {
        RenderHelper.renderPortal(renderShell, te, partialTicks, rotation, offset, size, false);
    }

    public static void renderPortal(RenderWorldShell renderShell, IContainsWorldShell te, float partialTicks) {
        RenderHelper.renderPortal(renderShell, te, partialTicks, 0.0f, null, null, false);
    }

    public static void renderPortal(RenderWorldShell renderShell, IContainsWorldShell te, float partialTicks, float rot) {
        RenderHelper.renderPortal(renderShell, te, partialTicks, rot, null, null, false);
    }

    public static void renderPortal(RenderWorldShell renderShell, IContainsWorldShell te, float partialTicks, float rot, Vec3d offset) {
        RenderHelper.renderPortal(renderShell, te, partialTicks, rot, offset, null, false);
    }

    public static void drawOutline(@Nullable Vec3d size) {
        if (size == null) {
            size = new Vec3d(1.0, 2.0, 0.0);
        }
        GlStateManager.func_179094_E();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderDoor.BLACK);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, size.field_72448_b, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(size.field_72450_a, size.field_72448_b, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(size.field_72450_a, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void setRenderGlobalWorld(WorldClient world) {
        Minecraft.func_71410_x().field_71438_f.field_72769_h = world;
        Minecraft.func_71410_x().field_71441_e = world;
    }

    public static void renderTransformAxis() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(-1.0, 0.0, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        bb.func_181662_b(1.0, 0.0, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        bb.func_181662_b(0.0, -1.0, 0.0).func_181666_a(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_181662_b(0.0, 1.0, 0.0).func_181666_a(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        bb.func_181662_b(0.0, 0.0, -1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bb.func_181662_b(0.0, 0.0, 1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawLine(Vec3d start, Vec3d end, float lineWidth, float innerLineWidth, Vec3d color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder wr = tes.func_178180_c();
        if (lineWidth > 0.0f) {
            GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)alpha);
            GlStateManager.func_187441_d((float)lineWidth);
            wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            tes.func_78381_a();
        }
        if (innerLineWidth > 0.0f) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)(alpha - 0.2f), (float)0.0f, (float)1.0f));
            GlStateManager.func_187441_d((float)innerLineWidth);
            wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            tes.func_78381_a();
        }
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Vec3d color) {
        RenderHelper.drawGlowingLine(start, end, thickness, color, 1.0f);
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Vec3d color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        int smoothFactor = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        int layers = 10 + smoothFactor * 20;
        GlStateManager.func_179094_E();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.func_179137_b((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int layer = 0; layer <= layers; ++layer) {
            if (layer < layers) {
                GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)(1.0f / (float)layers / 2.0f));
                GlStateManager.func_179132_a((boolean)false);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179132_a((boolean)true);
            }
            double size = (double)thickness + (layer < layers ? (double)layer * (1.25 / (double)layers) : 0.0);
            double d = (layer < layers ? 1.0 - (double)layer * (1.0 / (double)layers) : 0.0) * 0.1;
            double width = 0.0625 * size;
            double height = 0.0625 * size;
            double length = start.func_72438_d(end) + d;
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    public static void renderOffsetAABB(AxisAlignedBB boundingBox, double x, double y, double z) {
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_178969_c(x, y, z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)2884);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181708_h);
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        GL11.glEnable((int)2884);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public static void setupRenderLightning() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)32772);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        RenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
    }

    public static void finishRenderLightning() {
        RenderHelper.restoreLightMap();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    public static void restoreLightMap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    static {
        FOG_BUFFER = GLAllocation.func_74529_h((int)16);
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }
}

