/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.sounds.InteriorHum;
import net.tardis.mod.common.tileentity.TileEntityTardis;

public class MessageSwitchHum
implements IMessage {
    private int humID;
    private long blockpos;

    public MessageSwitchHum() {
    }

    public MessageSwitchHum(int soundID, long blockpos) {
        this.humID = soundID;
        this.blockpos = blockpos;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.humID = packetBuffer.readInt();
        this.blockpos = packetBuffer.readLong();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.humID);
        packetBuffer.writeLong(this.blockpos);
    }

    public static class Handler
    implements IMessageHandler<MessageSwitchHum, IMessage> {
        public IMessage onMessage(MessageSwitchHum message, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                BlockPos consolePos = BlockPos.func_177969_a((long)message.blockpos);
                TileEntityTardis tardis = (TileEntityTardis)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(consolePos);
                if (tardis != null) {
                    tardis.toggleHum(InteriorHum.hums.get(message.humID));
                }
            });
            return null;
        }
    }
}

