/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.client.worldshell.MessageSyncWorldShell;
import net.tardis.mod.network.NetworkHandler;

public class MessageRequestBOTI
implements IMessage {
    BlockPos pos = BlockPos.field_177992_a;
    MessageSyncWorldShell.EnumType type = MessageSyncWorldShell.EnumType.BLOCKS;
    int entityID = -1;

    public MessageRequestBOTI() {
    }

    public MessageRequestBOTI(BlockPos pos) {
        this.pos = pos;
    }

    public MessageRequestBOTI(int id) {
        this.entityID = id;
    }

    public void fromBytes(ByteBuf buf) {
        int type = buf.readInt();
        if (type == 1) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
        } else {
            this.entityID = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        int type = this.entityID == -1 ? 1 : 0;
        buf.writeInt(type);
        if (type == 1) {
            buf.writeLong(this.pos.func_177986_g());
        } else {
            buf.writeInt(this.entityID);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageRequestBOTI, IMessage> {
        public IMessage onMessage(final MessageRequestBOTI message, final MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (message.entityID != -1) {
                        Entity entity = ctx.getServerHandler().field_147369_b.func_71121_q().func_73045_a(message.entityID);
                        if (entity != null && entity instanceof IContainsWorldShell) {
                            IContainsWorldShell cont = (IContainsWorldShell)entity;
                            NetworkHandler.NETWORK.sendTo((IMessage)new MessageSyncWorldShell(cont.getWorldShell(), message.entityID, MessageSyncWorldShell.EnumType.BLOCKS), ctx.getServerHandler().field_147369_b);
                            NetworkHandler.NETWORK.sendTo((IMessage)new MessageSyncWorldShell(cont.getWorldShell(), message.entityID, MessageSyncWorldShell.EnumType.ENTITITES), ctx.getServerHandler().field_147369_b);
                        }
                    } else {
                        TileEntity te = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
                        if (te != null && te instanceof IContainsWorldShell) {
                            IContainsWorldShell shell = (IContainsWorldShell)te;
                            NetworkHandler.NETWORK.sendTo((IMessage)new MessageSyncWorldShell(shell.getWorldShell(), message.pos, MessageSyncWorldShell.EnumType.BLOCKS), ctx.getServerHandler().field_147369_b);
                            NetworkHandler.NETWORK.sendTo((IMessage)new MessageSyncWorldShell(shell.getWorldShell(), message.pos, MessageSyncWorldShell.EnumType.ENTITITES), ctx.getServerHandler().field_147369_b);
                        }
                    }
                }
            });
            return null;
        }
    }
}

