/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.handlers;

import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.mod.api.dimensions.IDimensionProperties;
import net.tardis.mod.cap.ITardisTracker;
import net.tardis.mod.common.blocks.BlockConsole;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityDalek;
import net.tardis.mod.common.entities.EntityTardis;
import net.tardis.mod.common.items.INeedMetadata;
import net.tardis.mod.common.items.ItemKey;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.recipes.RecipeCinnabar;
import net.tardis.mod.common.recipes.RecipeKey;
import net.tardis.mod.common.recipes.RecipeRemote;
import net.tardis.mod.common.systems.SystemTemporalGrace;
import net.tardis.mod.common.tileentity.TileEntityEgg;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.world.TardisWorldSavedData;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageConfigSync;
import net.tardis.mod.util.TardisTeleporter;
import net.tardis.mod.util.common.helpers.RiftHelper;
import net.tardis.mod.util.common.helpers.TardisHelper;

@Mod.EventBusSubscriber(modid="tardis")
public class TEventHandler {
    public static TardisWorldSavedData data;
    public static final ResourceLocation TRACKER_CAP;

    @SubscribeEvent
    public static void grav(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_73011_w instanceof IDimensionProperties) {
            IDimensionProperties prop = (IDimensionProperties)event.getEntityLiving().field_70170_p.field_73011_w;
            if (!event.getEntityLiving().field_70122_E && !prop.hasGravity()) {
                event.getEntityLiving().field_70181_x = prop.transformGrav(event.getEntityLiving().field_70181_x);
            }
        }
        ResourceLocation key = EntityList.func_191301_a((Entity)event.getEntityLiving());
        if (!TardisConfig.USE_ENTITIES.entities && key != null && key.func_110624_b().equals("tardis")) {
            event.getEntityLiving().func_70106_y();
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Block block : TBlocks.BLOCKS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "normal"));
        }
        for (Item item : TItems.items) {
            if (item.func_77614_k()) {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), list);
                for (int i = 0; i < list.size(); ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "type=" + i));
                }
                continue;
            }
            if (item instanceof INeedMetadata) {
                for (int meta : ((INeedMetadata)item).getMeta().keySet()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("tardis", ((INeedMetadata)item).getMeta().get(meta)), "inventory"));
                }
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : TBlocks.BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void loadTardises(WorldEvent.Load event) {
        data = (TardisWorldSavedData)event.getWorld().func_175693_T().func_75742_a(TardisWorldSavedData.class, "tardis");
        if (data == null) {
            data = new TardisWorldSavedData("tardis");
        }
    }

    @SubscribeEvent
    public static void saveTardises(WorldEvent.Save event) {
        event.getWorld().func_175693_T().func_75745_a("tardis", (WorldSavedData)data);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new RecipeKey("tardis:spare_key"));
        event.getRegistry().register((IForgeRegistryEntry)new RecipeCinnabar("tardis:cinnabar"));
        event.getRegistry().register((IForgeRegistryEntry)new RecipeRemote("remote_bind"));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void stopHurt(LivingHurtEvent event) {
        SystemTemporalGrace sys;
        TileEntityTardis tardis;
        EntityLivingBase e = event.getEntityLiving();
        if (!(e instanceof IMob) && !TardisHelper.getTardisForPosition((Vec3i)e.func_180425_c()).equals((Object)BlockPos.field_177992_a) && (tardis = (TileEntityTardis)e.field_70170_p.func_175625_s(TardisHelper.getTardisForPosition((Vec3i)e.func_180425_c()))) != null && tardis.getSystem(SystemTemporalGrace.class) != null && (sys = tardis.getSystem(SystemTemporalGrace.class)).getHealth() > 0.0f) {
            sys.setHealth(sys.getHealth() - 0.01f);
            event.setCanceled(true);
        }
        if (event.getEntityLiving().func_184187_bx() instanceof EntityTardis) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDalekShot(LivingAttackEvent e) {
        DamageSource source = e.getSource();
        Entity attacked = e.getEntity();
        if (source != null && attacked != null && source.func_76364_f() != null && attacked instanceof EntityDalek && source.func_76364_f() instanceof EntityArrow && !attacked.field_70170_p.field_72995_K) {
            attacked.field_70170_p.func_184133_a(null, e.getEntity().func_180425_c(), SoundEvents.field_187602_cF, SoundCategory.HOSTILE, 1.0f, 1.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void givePlayerKey(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player;
        if (TardisConfig.MISC.givePlayerKey && !TardisHelper.hasTardis((player = event.player).func_146103_bH().getId())) {
            InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)new ItemStack(TBlocks.tardis_coral));
        }
        if (!event.player.field_70170_p.field_72995_K) {
            try {
                HashMap<String, Long> map = new HashMap<String, Long>();
                File f = new File(event.player.field_70170_p.func_73046_m().func_71238_n() + "/pending_keys.json");
                if (f.exists()) {
                    JsonReader jr = new JsonReader((Reader)new FileReader(f));
                    jr.beginObject();
                    while (jr.hasNext()) {
                        map.put(jr.nextName(), Long.parseLong(jr.nextString()));
                    }
                    jr.endObject();
                    jr.close();
                    if (map.containsKey(event.player.func_146103_bH().getId().toString())) {
                        ItemStack stack = new ItemStack(TItems.key);
                        ItemKey.setPos(stack, BlockPos.func_177969_a((long)((Long)map.get(event.player.func_146103_bH().getId().toString()))));
                        event.player.field_71071_by.func_70441_a(stack);
                        GsonBuilder gb = new GsonBuilder();
                        gb.setPrettyPrinting();
                        JsonWriter jw = gb.create().newJsonWriter((Writer)new FileWriter(f));
                        jw.beginObject();
                        map.remove(event.player.func_146103_bH().getId().toString());
                        for (String name : map.keySet()) {
                            jw.name(name).value(((Long)map.get(name)).toString());
                        }
                        jw.endObject();
                        jw.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void giveManual(PlayerInteractEvent.RightClickBlock event) {
        World world;
        IBlockState state;
        if (!event.getWorld().field_72995_K && (state = (world = event.getWorld()).func_180495_p(event.getPos())).func_177230_c() instanceof BlockConsole) {
            EntityPlayer player = event.getEntityPlayer();
            if (player.func_184614_ca().func_77973_b() == Items.field_151110_aK) {
                InventoryHelper.func_180173_a((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)new ItemStack(TBlocks.tree_egg));
                player.func_184614_ca().func_190918_g(1);
            } else if (player.func_184614_ca().func_77973_b() == Items.field_151122_aG) {
                InventoryHelper.func_180173_a((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)new ItemStack(TItems.manual));
                player.func_184614_ca().func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void onMissingMappingSound(RegistryEvent.MissingMappings<SoundEvent> e) {
        for (RegistryEvent.MissingMappings.Mapping map : e.getAllMappings()) {
            if (!map.key.toString().equals("tardis:sonic")) continue;
            map.ignore();
        }
    }

    @SubscribeEvent
    public static void onMissingMappingEntity(RegistryEvent.MissingMappings<EntityEntry> e) {
        for (RegistryEvent.MissingMappings.Mapping map : e.getAllMappings()) {
            if (!map.key.toString().equals("tardis:raider")) continue;
            map.ignore();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        if (Loader.isModLoaded((String)"optifine")) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("mods.tardis.compat.optifine", new Object[0]), false);
        }
        if (!e.player.field_70170_p.field_72995_K) {
            NetworkHandler.NETWORK.sendTo((IMessage)new MessageConfigSync(TileEntityEgg.ITEMS), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void stopAttemptingTheStabby(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityLiving && event.getTarget() != null && event.getTarget().func_184187_bx() instanceof EntityTardis) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void saveChunkData(ChunkDataEvent.Save event) {
        RiftHelper.writeRiftStatus(event.getChunk(), event.getWorld(), event.getData());
    }

    @SubscribeEvent
    public static void loadChunkData(ChunkDataEvent.Load event) {
        RiftHelper.readRiftStatus(event.getChunk(), event.getWorld(), event.getData());
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        TileEntity te;
        if (event.getEntityPlayer().func_130014_f_().field_73011_w.getDimension() == TDimensions.TARDIS_ID && (te = event.getEntityPlayer().field_70170_p.func_175625_s(TardisHelper.getTardisForPosition((Vec3i)event.getPos()))) instanceof TileEntityTardis) {
            ((TileEntityTardis)te).addBedLoc(event.getEntityPlayer(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        TileEntityTardis tardis;
        TileEntity te;
        WorldServer ws;
        if (TardisHelper.hasTardis(event.player.func_110124_au()) && (ws = event.player.func_130014_f_().func_73046_m().func_71218_a(TDimensions.TARDIS_ID)) != null && (te = ws.func_175625_s(TardisHelper.getTardis(event.player.func_110124_au()))) instanceof TileEntityTardis && (tardis = (TileEntityTardis)te).getBedPos(event.player) != null) {
            BlockPos pos = tardis.getBedPos(event.player);
            if (!(ws.func_180495_p(pos).func_177230_c() instanceof BlockBed)) {
                return;
            }
            event.player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
            if (event.player.field_70170_p.field_73011_w.getDimension() != TDimensions.TARDIS_ID) {
                event.player.func_130014_f_().func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)event.player, TDimensions.TARDIS_ID, (ITeleporter)new TardisTeleporter());
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == TItems.tracker && !((ItemStack)event.getObject()).hasCapability(ITardisTracker.TRACKER, EnumFacing.DOWN)) {
            event.addCapability(TRACKER_CAP, (ICapabilityProvider)new ITardisTracker.TrackerProvider());
        }
    }

    static {
        TRACKER_CAP = new ResourceLocation("tardis", "tracker");
    }
}

