/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.systems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.tardis.mod.common.systems.TardisSubsystemBrokeEvent;

public class TardisSystems {
    public static HashMap<String, Class<? extends BaseSystem>> SYSTEMS = new HashMap();

    public static void register(String name, Class<? extends BaseSystem> sys) {
        if (SYSTEMS.containsKey(name)) {
            return;
        }
        SYSTEMS.put(name, sys);
    }

    public static BaseSystem createFromName(String s) {
        if (!SYSTEMS.containsKey(s)) {
            return null;
        }
        try {
            return SYSTEMS.get(s).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getIdBySystem(BaseSystem sys) {
        for (String key : SYSTEMS.keySet()) {
            Class<? extends BaseSystem> clazz = SYSTEMS.get(key);
            if (clazz != sys.getClass()) continue;
            return key;
        }
        return null;
    }

    public static ArrayList<String> getSystemsnames() {
        ArrayList<String> systemNames = new ArrayList<String>();
        for (Map.Entry<String, Class<? extends BaseSystem>> entry : SYSTEMS.entrySet()) {
            systemNames.add(entry.getKey());
        }
        return systemNames;
    }

    public static abstract class BaseSystem {
        private static Random rand = new Random();
        private float health = MathHelper.func_76131_a((float)((float)rand.nextInt(100) * 0.01f), (float)0.0f, (float)1.0f);

        public float getHealth() {
            return this.health;
        }

        public void setHealth(float health) {
            float f = health > 1.0f ? 1.0f : (this.health = health < 0.0f ? 0.0f : health);
            if (health <= 0.0f) {
                MinecraftForge.EVENT_BUS.post((Event)new TardisSubsystemBrokeEvent(this));
            }
        }

        public abstract void onUpdate(World var1, BlockPos var2);

        public void readFromNBT(NBTTagCompound tag) {
            this.health = tag.func_74760_g("health");
        }

        public NBTTagCompound writetoNBT(NBTTagCompound tag) {
            tag.func_74776_a("health", this.health);
            return tag;
        }

        public abstract void damage();

        public abstract Item getRepairItem();

        public boolean repair(ItemStack stack) {
            if (this.getHealth() < 1.0f) {
                this.setHealth(MathHelper.func_76131_a((float)(this.getHealth() + (float)(stack.func_77958_k() - stack.func_77952_i()) / 100.0f), (float)0.0f, (float)1.0f));
                return true;
            }
            return false;
        }

        public abstract String getNameKey();

        public abstract String getUsage();

        public abstract void wear();

        public boolean shouldStopFlight() {
            return this.getHealth() <= 0.0f;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() || super.equals(obj);
        }
    }
}

