/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.systems;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tardis.mod.common.TDamage;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.util.common.helpers.Helper;

public class SystemFluidLinks
extends TardisSystems.BaseSystem {
    int ticksToHurt = 0;

    public SystemFluidLinks() {
        this.setHealth(1.0f);
    }

    @Override
    public void onUpdate(World world, BlockPos consolePos) {
        if (this.getHealth() <= 0.0f && this.ticksToHurt > 0) {
            --this.ticksToHurt;
            if (!world.field_72995_K && world.func_72820_D() % 20L == 0L) {
                for (EntityLivingBase base : world.func_72872_a(EntityLivingBase.class, Helper.createBB(consolePos, 60.0))) {
                    base.func_70097_a(TDamage.SUFFICATION, 2.0f);
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.ticksToHurt = tag.func_74762_e("time");
    }

    @Override
    public NBTTagCompound writetoNBT(NBTTagCompound tag) {
        super.writetoNBT(tag);
        tag.func_74768_a("time", this.ticksToHurt);
        return tag;
    }

    @Override
    public void damage() {
        this.setHealth(this.getHealth() - 0.25f);
        if (this.getHealth() <= 0.0f) {
            this.ticksToHurt = 600;
        }
    }

    @Override
    public Item getRepairItem() {
        return TItems.fluid_link;
    }

    @Override
    public String getNameKey() {
        return "system.tardis.fluidlinks";
    }

    @Override
    public String getUsage() {
        return "Without this system, you will not be able to fly the TARDIS";
    }

    @Override
    public void wear() {
        this.setHealth(this.getHealth() - 0.015f);
        if (this.getHealth() <= 0.0f) {
            this.ticksToHurt = 600;
        }
    }
}

