/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.systems;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.enums.EnumTardisState;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;

public class SystemDimension
extends TardisSystems.BaseSystem {
    boolean shouldFix = false;
    boolean runOnce = false;

    public SystemDimension() {
        this.setHealth(1.0f);
    }

    @Override
    public void onUpdate(World world, BlockPos consolePos) {
        TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(consolePos);
        if (this.getHealth() <= 0.0f && tardis.dimension != TDimensions.TARDIS_ID) {
            if (this.runOnce) {
                tardis.setTardisState(EnumTardisState.DISABLED);
                for (EntityPlayer p : world.func_72872_a(EntityPlayer.class, Helper.createBB(consolePos, 128.0))) {
                    tardis.transferPlayer((Entity)p, false);
                    ControlDoor door = tardis.getDoor();
                    if (door == null) continue;
                    door.setOpen(false);
                }
                this.runOnce = false;
            }
            if (!world.field_72995_K) {
                for (EntityPlayer p : world.func_72872_a(EntityPlayer.class, Helper.createBB(consolePos, 20.0))) {
                    tardis.transferPlayer((Entity)p, false);
                }
            }
        }
        if (this.shouldFix) {
            tardis.setTardisState(EnumTardisState.NORMAL);
            this.shouldFix = false;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.shouldFix = tag.func_74767_n("fix");
    }

    @Override
    public NBTTagCompound writetoNBT(NBTTagCompound tag) {
        super.writetoNBT(tag);
        tag.func_74757_a("fix", this.shouldFix);
        return tag;
    }

    @Override
    public void damage() {
        this.setHealth(this.getHealth() - 0.2f);
        if (this.getHealth() <= 0.0f) {
            this.runOnce = true;
        }
    }

    @Override
    public Item getRepairItem() {
        return TItems.time_vector_generator;
    }

    @Override
    public String getNameKey() {
        return "systems.protocol.dimensions";
    }

    @Override
    public boolean shouldStopFlight() {
        return false;
    }

    @Override
    public String getUsage() {
        return "Without this system, your interior dimensions will collapse, leaving you unable to enter your TARDIS";
    }

    @Override
    public void wear() {
    }

    @Override
    public void setHealth(float health) {
        super.setHealth(health);
        if (this.getHealth() <= 0.0f) {
            this.runOnce = true;
        }
    }

    @Override
    public boolean repair(ItemStack stack) {
        boolean b = super.repair(stack);
        if (b) {
            this.shouldFix = true;
        }
        return b;
    }
}

